/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _DISP_WIN_H_
#define _DISP_WIN_H_

typedef	struct	tag_nt_window_t	*nt_window_tp;
typedef	struct	tag_nt_window_t{
	WINDOW	*wp;
	int	lines;
	int	cols;
	int org_x;
	int org_y;
	int key;
	void *data;
	const char *cmd_param;
	wchar_t *status_msg;
} nt_window_t;


extern nt_window_tp nt_disp_win_alloc(WINDOW *parent,
		int lines, int cols, int org_y, int org_x, 
		const char *cmd_param);
extern void nt_disp_win_free(nt_window_tp winp);
extern BOOL nt_disp_win_move(WINDOW *parent, nt_window_tp winp,
		int lines, int cols, int org_x, int org_y);

#endif /* _DISP_WIN_H_ */
