/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: syslog.c,v 1.9 2003/06/04 01:46:16 hiro Exp $
 */

/*
 *	ƥǽ
 */

#undef OMIT_SYSLOG
#include "jsp_kernel.h"
#include "time_event.h"
#include "syslog.h"

/*
 *  ƥȤ˰ͤʤCPUåå
 */
#define	lock_cpu()	(sense_context() ? i_lock_cpu() : t_lock_cpu())
#define	unlock_cpu()	(sense_context() ? i_unlock_cpu() : t_unlock_cpu())

#ifdef __logini

/*
 *  ХåեȤ˥뤿Υݥ
 */
SYSLOG	syslog_buffer[TCNT_SYSLOG_BUFFER];	/* Хåե */
UINT	syslog_count;			/* ХåեΥο */
UINT	syslog_head;			/* ƬΥγǼ */
UINT	syslog_tail;			/* ΥγǼ */
UINT	syslog_lost;			/* 줿ο */

/*
 *  Ϥ٤ν١ʥӥåȥޥåס
 */
UINT	syslog_logmask;			/* Хåե˵Ͽ٤ */
UINT	syslog_lowmask;			/* ٥Ϥ٤ */

/*
 *  ƥǽν
 */
void
syslog_initialize()
{
	syslog_count = 0;
	syslog_head = syslog_tail = 0;
	syslog_lost = 0;

	syslog_logmask = 0;
	syslog_lowmask = LOG_UPTO(LOG_NOTICE);
}     

#endif /* __logini */

/* 
 *  ν
 *
 *  CPUå֤¹ԥƥȤˤ餺ưǤ褦˼Ƥ롥
 */
#ifdef __vwri_log

SYSCALL ER
vwri_log(UINT prio, SYSLOG *p_log)
{
	BOOL	locked;

	locked = sense_lock();
	if (!locked) {
		lock_cpu();
	}

	/*
	 *  
	 */
	p_log->logtim = systim_offset + current_time;

	/*
	 *  Хåե˵Ͽ
	 */
	if ((syslog_logmask & LOG_MASK(prio)) != 0) {
		syslog_buffer[syslog_tail] = *p_log;
		syslog_tail++;
		if (syslog_tail >= TCNT_SYSLOG_BUFFER) {
			syslog_tail = 0;
		}
		if (syslog_count < TCNT_SYSLOG_BUFFER) {
			syslog_count++;
		}
		else {
			syslog_head = syslog_tail;
			syslog_lost++;
		}
	}

	/*
	 *  ٥
	 */
	if ((syslog_lowmask & LOG_MASK(prio)) != 0) {
		syslog_print(p_log, sys_putc);
	}

	if (!locked) {
		unlock_cpu();
	}
	return(E_OK);
}

#endif /* __vwri_log */

/*
 *  ХåեɽФ
 *
 *  CPUå֤¹ԥƥȤˤ餺ưǤ褦˼Ƥ롥
 */
#ifdef __vrea_log

SYSCALL ER_UINT
vrea_log(SYSLOG *p_log)
{
	BOOL	locked;
	ER_UINT	ercd;

	locked = sense_lock();
	if (!locked) {
		lock_cpu();
	}
	if (syslog_count > 0) {
		*p_log = syslog_buffer[syslog_head];
		syslog_count--;
		syslog_head++;
		if (syslog_head >= TCNT_SYSLOG_BUFFER) {
			syslog_head = 0;
		}
		ercd = (ER_UINT) syslog_lost;
		syslog_lost = 0;
	}
	else {
		ercd = E_OBJ;
	}
	if (!locked) {
		unlock_cpu();
	}
	return(ercd);
}

#endif /* __vrea_log */

/* 
 *  Ϥ٤ν٤
 */
#ifdef __vmsk_log

SYSCALL ER
vmsk_log(UINT logmask, UINT lowmask)
{
	syslog_logmask = logmask;
	syslog_lowmask = lowmask;
	return(E_OK);
}

#endif /* __vmsk_log */

/* 
 *  ƥǽνλ
 *
 *  Хåե˵Ͽ줿٥ϵǽѤƽϤ
 *  롥
 */
#ifdef __logter

void
syslog_terminate()
{
	syslog_printf("-- buffered messages --", NULL, sys_putc);
	syslog_output(sys_putc);
}

#endif /* __logter */
