/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: stdafx.h,v 1.5 2003/12/24 07:40:42 takayuki Exp $
 */

#if !defined(AFX_STDAFX_H__4015F3E9_0639_43DE_A5EE_C32ECAFDFC74__INCLUDED_)
#define AFX_STDAFX_H__4015F3E9_0639_43DE_A5EE_C32ECAFDFC74__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define STRICT
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif
#define _ATL_APARTMENT_THREADED

#pragma warning(push)
#pragma warning(disable:4786)

#include <list>
#include <map>
#include "range.h"
#include "messages.h"

typedef unsigned long DeviceID;

#include <atlbase.h>
// CComModule 饹饹ѤơС饤ɤ
// _Module ̾ѹʤǤ
class CExeModule : public CComModule
{
public:
	bool OnLogEvent(class CKernel * kernel, long sz, unsigned char * data);
	void RemoveLogWatcher(class CKernelLog * watcher);
	bool AddLogWatcher(class CKernelLog * watcher);
	bool RaiseInterrupt(unsigned long inhno);
	bool Write(class CKernel * kernel, unsigned long address, unsigned long sz, unsigned char data[]);
	bool Read(class CKernel * kernel, unsigned long address, unsigned long sz, unsigned char data[]);
	bool DetachKernel(class CKernel * kernel);
	bool AttachKernel(class CKernel * kernel);
	void RemoveViewer(class CInformation * view);
	void AddViewer(class CInformation * view);
	bool Unmap(class CDevice * device, unsigned long address);
	bool Map(class CDevice * device, Range map);
	bool DeleteDevice(class CDevice * device);
	DeviceID AddDevice(class CDevice * device);

		//˺줿ʬ
	LONG Unlock();
	DWORD dwThreadID;
	HANDLE hEventShutdown;
	void MonitorShutdown();
	bool StartMonitor();
	bool bActivity;


		//ʬǺäʬ
	CRITICAL_SECTION cs;
	class CKernel * Kernel;

	std::map<Range, class CDevice *> DeviceMap;
	std::list<class CDevice *> DeviceList;
	std::list<class CInformation *> ViewerList;
	std::list<class CKernelLog *> WatcherList;
	
	CExeModule(void);
	
};
extern CExeModule _Module;
#include <atlcom.h>

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ Ԥľɲäޤ

#pragma warning(pop)

#endif // !defined(AFX_STDAFX_H__4015F3E9_0639_43DE_A5EE_C32ECAFDFC74__INCLUDED)
