/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	G[`FbNp}N
 */

#ifndef _CHECK_H_
#define _CHECK_H_

#ifdef EXTENDED_STATUS

#define CHECK_ACCESS(exp) do {			\
	if (!(exp)) {						\
		ercd = E_OS_ACCESS;				\
		goto error_exit;				\
	}									\
} while (0)

#define D_CHECK_ACCESS(exp) do {		\
	if (!(exp)) {						\
		ercd = E_OS_ACCESS;				\
		goto d_error_exit;				\
	}									\
} while (0)

#define CHECK_CALLEVEL(clmask) do {		\
	if ((callevel & (clmask)) == 0) {	\
		ercd = E_OS_CALLEVEL;			\
		goto error_exit;				\
	}									\
} while (0)

#define CHECK_TSKID(tskid) do {			\
	if (!(tskid < tnum_task)) {			\
		ercd = E_OS_ID;					\
		goto error_exit;				\
	}									\
} while (0)

#define CHECK_RESID(resid) do {			\
	if (!(resid < tnum_resource)) {		\
		ercd = E_OS_ID;					\
		goto error_exit;				\
	}									\
} while (0)

#define CHECK_CNTID(cntid) do {			\
	if (!(cntid < tnum_counter)) {		\
		ercd = E_OS_ID;					\
		goto error_exit;				\
	}									\
} while (0)

#define CHECK_ALMID(almid) do {			\
	if (!(almid < tnum_alarm)) {		\
		ercd = E_OS_ID;					\
		goto error_exit;				\
	}									\
} while (0)

#define CHECK_NOFUNC(exp) do {			\
	if (!(exp)) {						\
		ercd = E_OS_NOFUNC;				\
		goto error_exit;				\
	}									\
} while (0)

#define CHECK_RESOURCE(exp) do {		\
	if (!(exp)) {						\
		ercd = E_OS_RESOURCE;			\
		goto error_exit;				\
	}									\
} while (0)

#define D_CHECK_STATE(exp) do {			\
	if (!(exp)) {						\
		ercd = E_OS_STATE;				\
		goto d_error_exit;				\
	}									\
} while (0)

#define CHECK_VALUE(exp) do {			\
	if (!(exp)) {						\
		ercd = E_OS_VALUE;				\
		goto error_exit;				\
	}									\
} while (0)

#else /* EXTENDED_STATUS */

#define CHECK_ACCESS(exp)		((void) 0)
#define D_CHECK_ACCESS(exp)		((void) 0)
#define CHECK_CALLEVEL(clmask)	((void) 0)
#define CHECK_TSKID(tskid)		((void) 0)
#define CHECK_RESID(resid)		((void) 0)
#define CHECK_CNTID(cntid)		((void) 0)
#define CHECK_ALMID(almid)		((void) 0)
#define CHECK_NOFUNC(exp)		((void) 0)
#define CHECK_RESOURCE(exp)		((void) 0)
#define D_CHECK_STATE(exp)		((void) 0)
#define CHECK_VALUE(exp)		((void) 0)

#endif /* EXTENDED_STATUS */
#endif /* _CHECK_H_ */
