#!/usr/bin/env ruby
require "rubygems"
require "mcmd"

require "lcm"
require "traDB.rb"
require "cls.rb"

module TAKE

#========================================================================
# 列挙関数:lcm 利用DB:TraDB
#========================================================================
class LcmEp
	#@@intMax=2147483646
	@@intMax=100

	attr_reader :pFile # パターンファイル
	attr_reader :db    # データベース
	attr_reader :cls   # クラス
	attr_reader :his   # クラス
	attr_reader :size  # 列挙されたパターン数

	# posトランザクションの重み計算
	# マニュアルの式(10)
	def calOmega(posCnt)
		return @@intMax/posCnt
	end

	# LCM最小サポートの計算
	# マニュアルの式(9)
	def calSigma(minPos,minGR,posCnt,negCnt)
		omegaF=@@intMax.to_f/posCnt.to_f
		beta=minPos
		w=posCnt.to_f/negCnt.to_f
		sigma=(beta*(omegaF-w/minGR)).to_i  # 切り捨て

		return sigma
	end

	def reduceTaxo(pat,items)
		tf=MCMD::Mtemp.new

		if items.taxonomy==nil then
			return pat
		end

		xxrt = tf.file
		taxo=items.taxonomy
		f=""
		f << "mtrafld f=#{taxo.itemFN},#{taxo.taxoFN} -valOnly a=__fld i=#{taxo.file} o=#{xxrt}"
		system(f)

		# xxrtの内容：oyakoに親子関係にあるアイテム集合のリストが格納される
		# __fld
		# A X
		# B X
		# C Y
		# D Z
		# E Z
		# F Z
		oyako=ZDD.constant(0)
		MCMD::Mcsvin.new("i=#{xxrt}"){|csv|
			csv.each{|fldVal|
				items=fldVal["__fld"]
				oyako=oyako+ZDD.itemset(items)
			}
		}

		# 親子リストにあるアイテム集合を含むパターンを削除する
		pat=pat.restrict(oyako).iif(0,pat)

		return pat
	end

	def initialize(db,cls)
		@temp=MCMD::Mtemp.new

		@db      = db         # 入力データベース
		@cls     = cls        # 分類クラス
		@file=@temp.file
		items=@db.items

		# 重みファイルの作成
		# pos,negのTransactionオブジェクトに対してLCMが扱う整数アイテムによるトランザクションファイルを生成する。
		# この時、pos,negを併合して一つのファイルとして作成され(@wNumTraFile)、
		# 重みファイル(@weightFile[クラス])の作成は以下の通り。
		# 1.対象クラスをpos、その他のクラスをnegとする。
		# 2. negの重みは-1に設定し、posの重みはcalOmegaで計算した値。
		# 3.@wNumTraFileの各行のクラスに対応した重みデータを出力する(１項目のみのデータ)。
		@weightFile = Hash.new
		@posWeight  = Hash.new
		@sigma      = Hash.new
		@cls.nameRecSize.each {|cName,posSize|
			@weightFile[cName] = @temp.file
			@posWeight[cName]=calOmega(posSize)

			f=""
			f << "mcut    -nfno f=#{@cls.clsFN}                          i=#{@cls.file} |"
			f << "mchgstr -nfn  f=0 c=#{cName}:#{@posWeight[cName]} O=-1 o=#{@weightFile[cName]}"
			system(f)
		}

		# アイテムをシンボルから番号に変換する。
		f=""
		f << "msortf f=#{@db.itemFN}                                                   i=#{@db.file} |"
		f << "mjoin  k=#{@db.itemFN} K=#{items.itemFN} m=#{items.file} f=#{items.idFN} |"
		f << "mcut   f=#{@db.idFN},#{items.idFN}                                       |"
		f << "msortf f=#{@db.idFN}                                                     |"
		f << "mtra   k=#{@db.idFN} f=#{items.idFN}                                     |"
		f << "mcut   f=#{items.idFN} -nfno                                             o=#{@file}"
		system(f)
	end


	# 各種パラメータを与えて列挙を実行
	def enumerate(type, minSup, minPos, minGR, minProb, uniform, lenLB=1, lenUB=4, top=10000)
		@type      = type
		@lenLB     = lenLB
		@lenUB     = lenUB
		@top       = top

		pFiles=[]
		tFiles=[]
		tf=MCMD::Mtemp.new
		@cls.nameRecSize.each{|cName,posSize|
			negSize=@db.size-posSize
			# minGRの計算
			if minGR then
				@minGR=minGR
			else
				if minProb then
					if uniform then
						@minGR = (minProb/(1-minProb)) * (@cls.size-1) # マニュアルの式(4)
					else
						@minGR = (minProb/(1-minProb)) * (negSize.to_f/posSize.to_f) # マニュアルの式(4)
					end
				end
			end

			# minSupCntの計算
			if minPos then
 				@minPos = minPos
			else
 				@minPos = (minSup * posSize.to_f + 0.99).to_i
			end

			xxp = tf.file
			xxt = tf.file
			@sigma[cName] = calSigma(@minPos,@minGR,posSize,negSize)

			if(top==0) then
				MCMD::lcm("type=#{@type} i=#{@file} s=#{@sigma[cName]} l=#{@lenLB} u=#{@lenUB} o=#{xxp} t=#{xxt} w=#{@weightFile[cName]}")
			else
				MCMD::lcm("type=#{@type} i=#{@file} s=#{@sigma[cName]} l=#{@lenLB} u=#{@lenUB} o=#{xxp} t=#{xxt} w=#{@weightFile[cName]} K=#{@top}")
			end

			# パターンのサポートを計算しCSV出力する
			MCMD::msgLog("output patterns to CSV file ...")
			xxpf=tf.file
			pFiles << xxpf
			items=@db.items
			f=""
			f << "mcut     -nfni f=0:pid,1:pattern,3:pc,4:nc             i=#{xxp} |"
			f << "mcal     c='round(${nc},1)' a=neg                      |"
			f << "mcal     c='round(${pc}/#{@posWeight[cName]},1)' a=pos |"
			f << "mdelnull f=pattern                                     |"
			f << "msetstr  v=#{cName} a=class                            |"
			f << "msetstr  v=#{posSize} a=posTotal                       |"
			f << "msetstr  v=#{@minPos} a=minPos                         |"
			f << "msetstr  v=#{@minGR} a=minGR                           |"
			f << "mcut     f=class,pid,pattern,pos,neg,posTotal,minPos,minGR o=#{xxpf}"
			system(f)

			s = MCMD::mrecount("i=#{xxpf}") # 列挙されたパターンの数
			MCMD::msgLog("the number of contrast patterns on class `#{cName}' enumerated is #{s}")

			# トランザクション毎に出現するパターンを書き出す
			MCMD::msgLog("output tid-patterns ...")
			xxtf=tf.file
			tFiles << xxtf

			xxt4=tf.file
			f=""
			f << "mcut    f=#{@db.idFN}                  i=#{@db.file} |"
			f << "muniq   k=#{@db.idFN}                  |"
			f << "mnumber S=0 a=__tno                    |"
			f << "msortf  f=__tno                        o=#{xxt4};"
			system(f)

			f=""
			f << "mcut     -nfni f=0:__tno,1:pid           i=#{xxt} |"
			f << "msortf   f=__tno                         |"
			f << "mjoin    k=__tno m=#{xxt4} f=#{@db.idFN} |"
			f << "msetstr  v=#{cName} a=class              |"
			f << "mcut     f=#{@db.idFN},class,pid         o=#{xxtf}"
			system(f)
		}

		# クラス別のパターンとtid-pidファイルを併合する
		items=@db.items
		@pFile = @temp.file
		@tFile = @temp.file

		xxtee0 = tf.file

		pAll=pFiles.join(",")
		tAll=tFiles.join(",")

		f=""
		# パターンファイル併合
		f << "mcat                i=#{pAll} |"
		f << "msortf  f=class,pid |"
		f << "mnumber S=0 a=ppid  o=#{xxtee0}"
		system(f)

		f=""
		# パターンファイル計算
		f << "mcut    f=class,ppid:pid,pattern,pos,neg,posTotal,minPos,minGR                     i=#{xxtee0} |"
		f << "msetstr v=#{@db.size} a=total                                                      |" # トータル件数
		f << "mcal    c='${total}-${posTotal}' a=negTotal                                        |" # negのトータル件数
		f << "mcal    c='${pos}/${posTotal}' a=support                                           |" # サポートの計算
  	f << "mcal    c='if(${neg}==0,1.797693135e+308,(${pos}/${posTotal})/(${neg}/${negTotal}))' a=growthRate |"

		if uniform then
			f << "mcal  c='(${pos}/${posTotal})/(${pos}/${posTotal}+(#{@cls.size}-1)*${neg}/${negTotal})' a=postProb |"
		else
			f << "mcal  c='${pos}/(${pos}+${neg})' a=postProb1 |"
		end
		f << "mcal  c='(${pos}/${posTotal})/(${pos}/${posTotal}+(#{@cls.size}-1)*${neg}/${negTotal})' a=postProb |"
		f << "msel    c='${pos}>=${minPos}&&${growthRate}>=${minGR}'                 |" # minSupとminGRによる選択
		f << "mvreplace vf=pattern m=#{items.file} K=#{items.idFN} f=#{items.itemFN} |"
		f << "mcut    f=class,pid,pattern,pos,neg,posTotal,negTotal,total,support,growthRate,postProb |"
		f << "mvsort  vf=pattern |"
		f << "msortf  f=class%nr,postProb%nr,pos%nr                                                                   o=#{@pFile}"
		system(f)

		if items.taxonomy then
			MCMD::msgLog("reducing redundant rules in terms of taxonomy ...")
			zdd=ZDD.constant(0)
			MCMD::Mcsvin.new("i=#{@pFile}"){|csv|
				csv.each{|fldVal|
					items=fldVal['pattern']
					zdd=zdd+ZDD.itemset(items)
				}
			}
			zdd=reduceTaxo(zdd,@db.items)

			xxp1=tf.file
			xxp2=tf.file
			xxp3=tf.file
			zdd.csvout(xxp1)

			f=""
			f << "mcut   -nfni f=1:pattern i=#{xxp1} |"
			f << "mvsort vf=pattern         |"
			f << "msortf f=pattern         o=#{xxp2}"
			system(f)

			f=""
			f << "msortf  f=pattern           i=#{@pFile} |"
			f << "mcommon k=pattern m=#{xxp2} |"
			f << "msortf  f=class%nr,postProb%nr,pos%nr o=#{xxp3}"
			system(f)
			system "mv #{xxp3} #{@pFile}"
		end

		xxp4=tf.file
		f=""
		f << "mcut    f=class,pid i=#{@pFile} |"
		f << "msortf  f=class,pid o=#{xxp4}"
		system(f)

		f=""
		# tid-pidファイル計算
		f << "mcat                                    i=#{tAll} |"
		f << "msortf   f=class,pid                    |"
		f << "mcommon  k=class,pid m=#{xxp4}          |"
		f << "msortf  f=class,pid                     |"
		f << "mjoin   k=class,pid f=ppid  m=#{xxtee0} |"
		f << "mcut    f=#{@db.idFN},class,ppid:pid    |"
		f << "msortf  f=#{@db.idFN},class,pid         o=#{@tFile}"
		system(f)

		@size = MCMD::mrecount("i=#{@pFile}") # 列挙されたパターンの数
		MCMD::msgLog("the number of emerging patterns enumerated is #{@size}")
	end

  def output(outpath)
		FileUtils.mv(@pFile,outpath+"/patterns.csv")
		FileUtils.mv(@tFile,outpath+"/tid_pat.csv")
	end
end

end #module
