#!/usr/bin/env ruby
require "rubygems"
require "mcmd"

module TAKE

#=分類問題における分類クラスを扱うクラス
# 新たにファイルを生成することはない。
class Cls
	@@limitSize = 10

	# クラス項目名(String)
	attr_reader :idFN
	attr_reader :clsFN
	attr_reader :file
	attr_reader :t_file

	# クラス名配列(=>String Array)
	attr_reader :names
	attr_reader :nameRecSize

	attr_reader :recSize

	# クラスサイズ(=>Fixnum)
	attr_reader :size

	#=== clsクラスの初期化
	# 初期化方法は以下の２通り。
	#* 与えられたCSVデータファイルによって初期化する。
	# 第1引数: ファイル名
	# 第2引数: そのファイル上のクラス項目名
	# 第3引数: クラス項目名(デフォルトは第2引数)
	# ファイルの中でクラス名が重複していても単一化して登録するので問題ない。
	# ex. cls=Cls.new("tra.csv","customer type")
	#
	#* クラス項目名とクラス名配列を与えて初期化する。
	# 第1引数: クラス項目名(String)
	# 第2引数: クラス名配列(String Array)
	# ex. cls=Cls.new("customer type",["good","normal","bad"])
	#
	#====機能
	#* クラス数をカウントする(Cls.size)。
	#* クラス名別件数を取得する(Cls.nameSize配列)。
	def initialize(iFile,idFN,clsFN,t_iFile=nil)
		@temp=MCMD::Mtemp.new

		@iFile = iFile
		@iPath = File.expand_path(@iFile)
		@idFN  = idFN
		@clsFN = clsFN
		@file  = @temp.file
		@t_iFile = t_iFile

		# tid-クラス項目名ファイルの生成
		f=""
		f << "mcut   f=#{@idFN},#{@clsFN} i=#{@iFile} |"
		f << "msortf f=#{@idFN},#{@clsFN} |"
		f << "muniq  k=#{@idFN},#{@clsFN} o=#{@file}"
		system(f)

		# レコード数の計算
		@recSize = MCMD::mrecount("i=#{@file}")

		# クラス別件数
		tf=MCMD::Mtemp.new
		xx1=tf.file
		f=""
		f << "mcut   f=#{@clsFN}         i=#{@iFile} |"
		f << "msortf f=#{@clsFN}         |"
		f << "mcount k=#{@clsFN} a=count o=#{xx1}"
		system(f)

		# クラス数
		@size = MCMD::mrecount("i=#{xx1}")

		# 文字列としてのクラス別件数配列を数値配列に変換する
		@names = Array.new
		@nameRecSize = Hash.new
		MCMD::Mcsvin.new("i=#{xx1}"){|csv|
			csv.each{|fldVal|
				@names.push fldVal[csv.names[0]]
				@nameRecSize[fldVal[csv.names[0]]]=fldVal[csv.names[1]].to_i
			}
		}

		# テストファイル
		if @t_iFile!=nil then
			@t_file = @temp.file # テスト名
			f=""
			f << "mcut   f=#{@idFN},#{@clsFN} i=#{@t_iFile} |"
			f << "msortf f=#{@idFN},#{@clsFN} |"
			f << "muniq  k=#{@idFN},#{@clsFN} o=#{@t_file}"
			system(f)
		end
	end

public

	def replaceFile(train,test)
		@file   = train
		@t_file = test

		# レコード数の計算
		@recSize = MCMD::mrecount("i=#{@file}")

		# クラス別件数
		xx1=MCMD::Mtemp.new #("xx1","",true)
		f=""
		f << "mcut   f=#{@clsFN}         i=#{@iFile} |"
		f << "msortf f=#{@clsFN}         |"
		f << "mcount k=#{@clsFN} a=count o=#{xx1.name}"
		system(f)

		# 文字列としてのクラス別件数配列を数値配列に変換する
		@names.each{|cname|
			@nameRecSize[cname] = 0
		}
		Mcsv.new("i=#{xx1.name}").each{|fldName,fldVal,recNo|
			@nameRecSize[fldVal[fldName[0]]] = fldVal[fldName[1]].to_i
		}
	end
end

end #module 
