package jp.sourceforge.ocmml.android.modulators;

import jp.sourceforge.ocmml.android.Sample;

public final class FCNoise extends Modulator {
    private static final int FC_NOISE_PHASE_SHIFT = 10;
    private static final int FC_NOISE_PHASE_SECOND = 1789773 << FC_NOISE_PHASE_SHIFT;
    private static final int FC_NOISE_PHASE_DELTA = FC_NOISE_PHASE_SECOND / Sample.RATE;

    public FCNoise() {
        super();
        setLongMode();
        mFcr = 0x8000;
        mValue = getNoiseValue();
        setNoiseFrequencyIndex(0);
    }

    @Override
	public double getNextSampleOfs(int ofs) {
        int fcr = mFcr, phase = mPhase, delta = FC_NOISE_PHASE_DELTA;
        double value = mValue;
        getNextSampleFromDelta(delta);
        if (mPhase >= mFrequencyShift) {
            mPhase = mFrequencyShift;
            mValue = getNoiseValue();
        }
        mFcr = fcr;
        mPhase = phase;
        getNextSample();
        return value;
    }

    @Override
    public void addPhase(int time) {
        mPhase = mPhase + FC_NOISE_PHASE_DELTA * time;
        while (mPhase >= mFrequencyShift) {
            mPhase -= mFrequencyShift;
            mValue = getNoiseValue();
        }
    }

    @Override
    public void resetPhase() {
        return;
    }

    public void setShortMode() {
        mSnz = 6;
    }

    public void setLongMode() {
        mSnz = 1;
    }

    @Override
    public double getNextSample() {
        double value = mValue;
        int delta = FC_NOISE_PHASE_DELTA;
        getNextSampleFromDelta(delta);
        if (mPhase >= mFrequencyShift) {
            mPhase -= mFrequencyShift;
            mValue = getNoiseValue();
        }
        return value;
    }

    public void setNoiseFrequencyIndex(int value) {
        int index = Math.min(Math.max(value, 0), 15);
        mFrequencyShift = (int)sInterval[index] << FC_NOISE_PHASE_SHIFT;
    }

    @Override
    public void setFrequency(double value) {
        mFrequency = (int)(FC_NOISE_PHASE_SECOND / value);
    }

    public double getNoiseValue() {
        mFcr >>= 1;
        mFcr |= ((mFcr ^ (mFcr >> mSnz)) & 1) << 15;
        return (mFcr & 1) == 1 ? 1.0 : -1.0;
    }

    private void getNextSampleFromDelta(int delta) {
        double sum = 0, count = 0;
        while (delta >= mFrequencyShift) {
            delta -= mFrequencyShift;
            mPhase = 0;
            sum += getNoiseValue();
            count += 1.0;
        }
        if (count > 0)
            mValue = sum / count;
        mPhase += delta;
    }

    private static double[] sInterval = new double[] {
        0x004, 0x008, 0x010, 0x020, 0x040, 0x060, 0x080, 0x0a0,
        0x0ca, 0x0fe, 0x17c, 0x1fc, 0x2fa, 0x3f8, 0x7f2, 0xfe4
    };
    private int mFcr;
    private int mSnz;
    private double mValue;
}
