package jp.sourceforge.ocmml.android;

import jp.sourceforge.ocmml.android.modulators.FCNoise;
import jp.sourceforge.ocmml.android.modulators.FCTriangle;
import jp.sourceforge.ocmml.android.modulators.GBLongNoise;
import jp.sourceforge.ocmml.android.modulators.GBShortNoise;
import jp.sourceforge.ocmml.android.modulators.GBWave;
import jp.sourceforge.ocmml.android.modulators.Modulator;
import jp.sourceforge.ocmml.android.modulators.Noise;
import jp.sourceforge.ocmml.android.modulators.Pulse;
import jp.sourceforge.ocmml.android.modulators.Saw;
import jp.sourceforge.ocmml.android.modulators.Sine;
import jp.sourceforge.ocmml.android.modulators.Triangle;

public class Oscillator {
    public static final int SINE = 0;
    public static final int SAW = 1;
    public static final int TRIANGLE = 2;
    public static final int PULSE = 3;
    public static final int NOISE = 4;
    public static final int FC_PULSE = 5;
    public static final int FC_TRIANGLE = 6;
    public static final int FC_NOISE = 7;
    public static final int FC_SHORT_NOISE = 8;
    public static final int FC_DPCM = 9;
    public static final int GB_WAVE = 10;
    public static final int GB_LONG_NOISE = 11;
    public static final int GB_SHORT_NOISE = 12;
    public static final int MAX = 13;

    public Oscillator() {
        mModulators[SINE] = new Sine();
        mModulators[SAW] = new Saw();
        mModulators[TRIANGLE] = new Triangle();
        mModulators[PULSE] = new Pulse();
        mModulators[NOISE] = new Noise();
        mModulators[FC_PULSE] = new Pulse();
        mModulators[FC_TRIANGLE] = new FCTriangle();
        mModulators[FC_NOISE] = new FCNoise();
        mModulators[FC_SHORT_NOISE] = new FCNoise();
        mModulators[FC_DPCM] = null;
        mModulators[GB_WAVE] = new GBWave();
        mModulators[GB_LONG_NOISE] = new GBLongNoise();
        mModulators[GB_SHORT_NOISE] = new GBShortNoise();
        setForm(PULSE);
    }

    public Modulator getModulatorFromForm(int form) {
        int index = Math.min(Math.max(form, SINE), MAX - 1);
        return mModulators[index];
    }

    public void makeAsLFO() {
        Noise noise = (Noise) mModulators[NOISE];
        noise.setResettingPhase(false);
    }

    public int getForm() {
        return mForm;
    }

    public void setForm(int value) {
        int index = Math.min(Math.max(value, SINE), MAX - 1);
        mForm = index;
        switch (index) {
        case NOISE:
            Noise noise = (Noise) mModulators[NOISE];
            noise.restoreFrequency();
            break;
        case FC_NOISE:
            FCNoise fcNoise = (FCNoise) mModulators[FC_NOISE];
            fcNoise.setLongMode();
        case FC_SHORT_NOISE:
            FCNoise fcShortNoise = (FCNoise) mModulators[FC_SHORT_NOISE];
            fcShortNoise.setShortMode();
        default:
            break;
        }
    }

    public Modulator getCurrentModulator() {
        return mModulators[mForm];
    }

    private Modulator[] mModulators = new Modulator[MAX];
    private int mForm;
}
