/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;
    NativeCall caller;
    NativeFunction funObj;
    Scriptable thisObj;
    Object[] originalArgs;
    public int debugPC;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeCall nativeCall = new NativeCall();
        nativeCall.prototypeFlag = true;
        nativeCall.addAsPrototype(1, context, scriptable, bl);
    }

    NativeCall(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, Object[] objectArray) {
        this.funObj = nativeFunction;
        this.thisObj = scriptable2;
        this.setParentScope(scriptable);
        this.caller = context.currentActivation;
        context.currentActivation = this;
        this.originalArgs = objectArray == null ? ScriptRuntime.emptyArgs : objectArray;
        String[] stringArray = nativeFunction.argNames;
        if (stringArray != null) {
            int n = 0;
            while (n < nativeFunction.argCount) {
                Scriptable scriptable3 = n < objectArray.length ? objectArray[n] : Undefined.instance;
                super.put(stringArray[n], (Scriptable)this, (Object)scriptable3);
                ++n;
            }
        }
        super.put("arguments", (Scriptable)this, (Object)new Arguments(this));
    }

    private NativeCall() {
    }

    public String getClassName() {
        return "Call";
    }

    private static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        if (!bl) {
            throw Context.reportRuntimeError1("msg.only.from.new", "Call");
        }
        ScriptRuntime.checkDeprecated(context, "Call");
        NativeCall nativeCall = new NativeCall();
        nativeCall.setPrototype(ScriptableObject.getObjectPrototype(function));
        return nativeCall;
    }

    NativeCall getActivation(Function function) {
        NativeCall nativeCall = this;
        do {
            if (nativeCall.funObj != function) continue;
            return nativeCall;
        } while ((nativeCall = nativeCall.caller) != null);
        return null;
    }

    public Function getFunctionObject() {
        return this.funObj;
    }

    public Object[] getOriginalArguments() {
        return this.originalArgs;
    }

    public NativeCall getCaller() {
        return this.caller;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag && n == 1) {
            return 1;
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag && n == 1) {
            return NativeCall.jsConstructor(context, objectArray, idFunction, scriptable2 == null);
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    protected String getIdName(int n) {
        if (this.prototypeFlag && n == 1) {
            return "constructor";
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        return string.equals("constructor") ? 1 : 0;
    }
}

