/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;

public final class AtomicSequenceConverter
extends UnaryExpression {
    private AtomicType reqItemType;
    private BuiltInAtomicType requiredPrimitiveType;

    public AtomicSequenceConverter(Expression expression, AtomicType atomicType) {
        super(expression);
        this.reqItemType = atomicType;
        this.requiredPrimitiveType = (BuiltInAtomicType)atomicType.getPrimitiveItemType();
        ExpressionTool.copyLocationInfo(expression, this);
    }

    public AtomicType getRequiredPrimitiveType() {
        return this.requiredPrimitiveType;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof Literal) {
            return Literal.makeLiteral(new SequenceExtent(this.iterate(staticContext.makeEarlyEvaluationContext())));
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (typeHierarchy.isSubType(this.operand.getItemType(typeHierarchy), this.reqItemType)) {
            Expression.setParentExpression(this.operand, this.getParentExpression());
            return this.operand;
        }
        if (!Cardinality.allowsMany(this.operand.getCardinality())) {
            CastExpression castExpression = new CastExpression(this.operand, this.reqItemType, (this.operand.getCardinality() & 0x2000) != 0);
            ExpressionTool.copyLocationInfo(this, castExpression);
            castExpression.setParentExpression(this.getParentExpression());
            return castExpression;
        }
        return this;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public SequenceIterator iterate(final XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                return ((AtomicValue)item).convert(AtomicSequenceConverter.this.requiredPrimitiveType, xPathContext);
            }
        };
        return new ItemMappingIterator(sequenceIterator, itemMappingFunction);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        return ((AtomicValue)item).convert(this.requiredPrimitiveType, xPathContext);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.reqItemType;
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredPrimitiveType == ((AtomicSequenceConverter)object).requiredPrimitiveType;
    }

    protected String displayOperator(Configuration configuration) {
        return "convert items to " + this.reqItemType.toString(configuration.getNamePool());
    }
}

