using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Xml.Serialization;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Acl.Models.Base;
using OFW.Models;

namespace OFW.Acl.Models
{
    /// <summary>
    /// AclRoles GeBeB`
    /// </summary>
    [Serializable()]
    [System.Xml.Serialization.XmlType(TypeName = "Role")]
    public class AclRolesEntity : AclRolesTableRow, ICloneable, OFW.Acl.IAclRole
	{
        List<AclRolesEntity> _children;
        AclRolesEntity _parent;
        /// <summary>
        /// e̖O
        /// </summary>
        public string parentName;
        /// <summary>
        /// ftHg\z
        /// </summary>
        public AclRolesEntity() : base()
        {
            _children = new List<AclRolesEntity>();
            _parent = null;

        }
	
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public override object Clone()
        {
            AclRolesEntity clone = new AclRolesEntity();
            clone.CopyFrom(this);
			
			//TODO: ɂ̃NX̓Ǝ̃N[

            return clone;
        }
        /// <summary>
        /// nꂽp[^IuWFNg̓ẽIuWFNgɃRs[B
        /// </summary>
        /// <param name="source">Rs[̃GeBeB</param>
        public virtual void CopyFrom(AclRolesEntity source)
        {
        	base.CopyFrom(source);

			//TODO: ɂ̃NX̓Ǝ̃Rs[
        }

        #region ITreeNode o

        /// <summary>
        /// q邩
        /// </summary>
        public bool hasChild
        {
            get { return (rightSide - leftSide) > 1; }
        }
        /// <summary>
        /// c
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public bool isAncestorOf(OFW.Models.ITreeNode target)
        {
            AclRolesEntity entity = target as AclRolesEntity;

            return (entity.leftSide > leftSide && entity.leftSide < rightSide);
        }
        /// <summary>
        /// q
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public bool isDescendantOf(OFW.Models.ITreeNode target)
        {
            return target.isAncestorOf(this);
        }
        /// <summary>
        /// qvf̗
        /// </summary>
        [XmlIgnore]
        public IEnumerable<OFW.Models.ITreeNode> children
        {
            get
            {
                return _children.ToArray();
            }
            set
            {
                _children.Clear();
                IEnumerator<ITreeNode> e = value.GetEnumerator();
                while (e.MoveNext())
                {
                    _children.Add(e.Current as AclRolesEntity);
                }
            }
        }
        /// <summary>
        /// evf
        /// </summary>
        [XmlIgnore]
        public OFW.Models.ITreeNode parent
        {
            get
            {
                return _parent;
            }
            set
            {
                _parent = value as AclRolesEntity;
            }
        }
        /// <summary>
        /// qǉ
        /// </summary>
        /// <param name="child"></param>
        public void appendChild(OFW.Models.ITreeNode child)
        {
            _children.Add(child as AclRolesEntity);
            child.parent = this;
        }
        /// <summary>
        /// q폜
        /// </summary>
        /// <param name="child"></param>
        public void removeChild(OFW.Models.ITreeNode child)
        {
            AclRolesEntity childNode = child as AclRolesEntity;
            int position = _children.FindIndex(delegate(AclRolesEntity t) { return t.name == childNode.name; });
            if (position < 0)
            {
            }
            else
            {
                _children.RemoveAt(position);
            }
        }
        /// <summary>
        /// pX([g炱̗vf܂łǂ邽߂̃L[)̕
        /// </summary>
        public string pathString
        {
            get { return TreeNode.createPathString(this); }
        }
        /// <summary>
        /// pX([g炱̗vf܂łǂ邽߂̃L[)
        /// </summary>
        public List<string> path
        {
            get { return TreeNode.createPath(this); }
        }
        /// <summary>
        /// wpX̗vf
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public OFW.Models.ITreeNode find(IEnumerable<string> path)
        {
            return TreeNode.find(this, path); ;
        }

        #endregion
        /// <summary>
        /// f[^삩̃}bsO
        /// </summary>
        /// <param name="row"></param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("parent_name")) { this.parentName = StringUtil.StringValue(row["parent_name"]); }
            base.Map(row);
        }


    }

}