using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Acl.Models.Base;

namespace OFW.Acl.Models
{
    /// <summary>
    /// AclRules GeBeB`
    /// </summary>
    [Serializable()]
	public class AclRulesEntity : AclRulesTableRow,ICloneable,IAclRule
	{
        /// <summary>
        /// ftHg\z
        /// </summary>
        public AclRulesEntity() : base()
        {
        }
	
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public override object Clone()
        {
            AclRulesEntity clone = new AclRulesEntity();
            clone.CopyFrom(this);
			
			//TODO: ɂ̃NX̓Ǝ̃N[

            return clone;
        }
        /// <summary>
        /// nꂽp[^IuWFNg̓ẽIuWFNgɃRs[B
        /// </summary>
        /// <param name="source">Rs[̃GeBeB</param>
        public virtual void CopyFrom(AclRulesEntity source)
        {
        	base.CopyFrom(source);

			//TODO: ɂ̃NX̓Ǝ̃Rs[
        }
        #region IAclRule o

        /// <summary>
        /// 
        /// </summary>
        public AclPrivilege privilege
        {
            get
            {
                AclPrivilege priv = AclPrivilege.None;
                priv |= (AclPrivilege)(this._allowCreate * (int)AclPrivilege.Create);
                priv |= (AclPrivilege)(this._allowRead * (int)AclPrivilege.Read);
                priv |= (AclPrivilege)(this._allowUpdate * (int)AclPrivilege.Update);
                priv |= (AclPrivilege)(this._allowDelete * (int)AclPrivilege.Delete);
                return priv;
            }
            set
            {
                this._allowCreate = NumberUtil.BoolToInt((value & AclPrivilege.Create) == AclPrivilege.Create);
                this._allowRead = NumberUtil.BoolToInt((value & AclPrivilege.Read) == AclPrivilege.Read);
                this._allowUpdate = NumberUtil.BoolToInt((value & AclPrivilege.Update) == AclPrivilege.Update);
                this._allowDelete = NumberUtil.BoolToInt((value & AclPrivilege.Delete) == AclPrivilege.Delete);
            }
        }
        string _resourceName;
        /// <summary>
        /// \[X
        /// </summary>
        public string resourceName
        {
            get
            {
                return _resourceName;
            }
            set
            {
                this._resourceName = value;
            }
        }
        string _roleName;
        /// <summary>
        /// [
        /// </summary>
        public string roleName
        {
            get
            {
                return this._roleName;
            }
            set
            {
                this._roleName = value;
            }
        }
        /// <summary>
        /// H
        /// </summary>
        /// <param name="priv">Ώی</param>
        /// <returns></returns>
        public bool isAllowed(AclPrivilege priv)
        {
            return (priv & this.privilege) == priv;
        }
        /// <summary>
        /// ہH
        /// </summary>
        /// <param name="priv">Ώی</param>
        /// <returns></returns>
        public bool isDenied(AclPrivilege priv)
        {
            return !((priv & this.privilege) == priv);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="priv">Ώی</param>
        public void allow(AclPrivilege priv)
        {
            this.privilege |= priv;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="priv">Ώی</param>
        public void deny(AclPrivilege priv)
        {
            this.privilege &= (AclPrivilege.All ^ priv);
        }

        #endregion
        /// <summary>
        /// 
        /// </summary>
        /// <param name="row"></param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("resource_name")) { this._resourceName = StringUtil.StringValue(row["resource_name"]); }
            if (cols.Contains("role_name")) { this._roleName = StringUtil.StringValue(row["role_name"]); }

            base.Map(row);
        }

	}

}