using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.IO;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using OFW.Util;
namespace OFW.AspxCommon
{
    /// <summary>
    /// HTTP𗘗pt@C̃Abv[hA_E[h
    /// </summary>
    [Obsolete("OFW.Web.Util.Download ܂ OFW.Web.Util.UploadgpĂ")]
    public class HttpFile
    {
        /// <summary>
        /// 傫ȃt@Cꍇ̃obt@TCY
        /// </summary>
        public const int READ_BUFFER_SIZE = 1024000;

        Dictionary<string, string> mMimeTypes;
        /// <summary>
        /// SaveUploadFile
        /// asp:FileUploadɂAbv[h̎t
        /// </summary>
        /// <param name="aDestinationFileName">ۑ̃t@C</param>
        /// <param name="aFileUpload">t@CAbv[hT[o[Rg[</param>
        /// <returns>ۑt@C̃TCY</returns>
        /// <example>
        /// <code>
        /// //HTML"uploadfile"ƂăAbv[hRg[zu
        /// //aspx
        /// &lt;ASP:FIleUpload ID="uploadfile" runat="server" /&gt;
        /// //T[o["c:\doc\document.txt"ɕۑ
        /// //aspx.cs
        /// HttpFile httpFile = new HttpFile();
        /// int rc = httpFile.SaveUploadFile("c:\doc\document.txt","uploadfile",this.Request);
        /// </code>
        /// </example>
        public int SaveUploadFile(string aDestinationFileName, FileUpload aFileUpload)
        {
            //TODO:t@Cw肳ȂƂ̏
            if (aFileUpload.PostedFile.FileName == "")
            {
                return 0;
            }
            //TODO:̃t@Cw肳ꂽƂ̌x
            //[U[݂Ȃt@Cw肵̂̃t@Cw肵͕̂sB
            if (aFileUpload.PostedFile.ContentLength == 0)
            {
                return 0;
            }

            
            BinaryReader reader = new BinaryReader(aFileUpload.PostedFile.InputStream);
            byte[] data = reader.ReadBytes(aFileUpload.PostedFile.ContentLength);
            reader.Close();
            return WriteBinary(aDestinationFileName, data, FileMode.Create);
        }
        /// <summary>
        /// SaveUploadFile
        /// multipart/form-dataɂAbv[h̎t
        /// </summary>
        /// <param name="aDestinationFileDir">ۑfBNg</param>
        /// <param name="aParamName">wp[^(input name=""Ɏw肳閼)</param>
        /// <param name="aRequest">y[WRequestIuWFNg</param>
        /// <returns>ۑt@C̃TCY</returns>
        /// <remarks>RequestIuWFNgaParamNameŎw肳ꂽAbv[ht@CǂݎۑfBNgɕۑ<br />
        /// ۑt@C̓Abv[ht@C̉E[
        /// </remarks>
        /// <example>
        /// <code>
        /// //HTML"uploadfile"ƂăAbv[hRg[zu
        /// //aspx
        /// <input type="file" name="uploadfile"></input>
        /// 
        /// //T[o["c:\doc\"ɕۑ
        /// //aspx.cs
        /// HttpFile httpFile = new HttpFile();
        /// int rc = httpFile.SaveUploadFile("c:\doc\","uploadfile",this.Request);
        /// </code>
        /// </example>
        public int SaveUploadFile(string aDestinationFileDir, string aParamName, HttpRequest aRequest)
        {
            HttpPostedFile postedFile = aRequest.Files[aParamName];
            if (postedFile == null) return 0;
            if (postedFile.FileName == "") return 0;
            if (postedFile.ContentLength == 0) return 0;
            string baseName = "";
            int lastPos = postedFile.FileName.LastIndexOf('\\');
            baseName = postedFile.FileName.Substring(lastPos + 1);
            if (baseName == "") return 0;

            BinaryReader reader = new BinaryReader(postedFile.InputStream);
            byte[] data = reader.ReadBytes(postedFile.ContentLength);
            reader.Close();
            return WriteBinary(aDestinationFileDir + "\\" + baseName, data, FileMode.Create);
        }
        /// <summary>
        /// t@C̃_E[h
        /// </summary>
        /// <param name="aSourceFileName">_E[h</param>
        /// <param name="aDestinationFileName">NCAgɕ\t@C</param>
        /// <param name="aResponse">_E[h{̂HttpResponse</param>
        /// <returns>MoCg</returns>
        /// <example>
        /// <code>
        /// //T[o["c:\document.txt""userfile.txt"Ƃă_E[h
        /// HttpFile httpFile = new HttpFile();
        /// int rc = httpFile.Download("c:\document.txt","userfile.txt",this.Request);
        /// </code>
        /// </example>
        public int Download(string aSourceFileName, string aDestinationFileName, System.Web.HttpResponse aResponse)
        {
            if (aSourceFileName.Trim() == "") return 0;


            if (!System.IO.File.Exists(aSourceFileName)) return 0;
            long readLimit = new FileInfo(aSourceFileName).Length;

            byte[] data = ReadBinary(aSourceFileName, FileMode.Open);

            string filename = "";
            HttpRequest request = HttpContext.Current.Request;
            if (request.UserAgent.Contains("MSIE"))
            {
                //filename = StringUtil.UrlEncodeEx(aDestinationFileName);
                aResponse.HeaderEncoding = Encoding.GetEncoding("Shift_JIS");
                filename = aDestinationFileName;

            }
            else
            {
                filename = aDestinationFileName;
            }

            aResponse.ContentType = "appliation/octet-stream";
            aResponse.AppendHeader("Content-Disposition", "attachment;filename=" + filename + "");
            aResponse.AppendHeader("content-length", data.Length.ToString());           
            aResponse.BinaryWrite(data);
            aResponse.End();
            return (int)readLimit;
        }

		/// <summary>
		/// Ytt@C\B
		/// </summary>
		/// <param name="aSourceFileName"></param>
		/// <param name="aDestinationFileName"></param>
		/// <param name="aResponse"></param>
		/// <returns></returns>
		public int Display(string aSourceFileName, string aDestinationFileName, System.Web.HttpResponse aResponse)
		{
			if (aSourceFileName.Trim() == "") return 0;


            if (!System.IO.File.Exists(aSourceFileName)) return 0;
            long readLimit = new FileInfo(aSourceFileName).Length;

			byte[] data = ReadBinary(aSourceFileName, FileMode.Open);

			string filename = "";
			HttpRequest request = HttpContext.Current.Request;
			if (request.UserAgent.Contains("MSIE"))
			{
                aResponse.HeaderEncoding = Encoding.GetEncoding("Shift_JIS");
				filename = aDestinationFileName;
			}
			else
			{
				filename = aDestinationFileName;
			}

            aResponse.ContentType = getContentType(aDestinationFileName);
            aResponse.AppendHeader("content-length", data.Length.ToString());
            aResponse.BinaryWrite(data);
			aResponse.End();
			return (int)readLimit;
		}
        string getContentType(string filename)
        {
            string contentType = "application/octet-stream";
            int lastExt = filename.LastIndexOf(".");
            if (lastExt < 0) return contentType;
            string ext = filename.Substring(lastExt + 1).ToLower();

            if (mMimeTypes == null) loadMimeTypes();

            if (!mMimeTypes.ContainsKey(ext)) return contentType ;

            return mMimeTypes[ext];
        }
        void loadMimeTypes()
        {
            mMimeTypes = new Dictionary<string, string>();

            StreamReader reader = null;
            try
            {
                string basePath = HttpContext.Current.Server.MapPath("~/");
                reader = new StreamReader( basePath + "\\mime.types");
                while (!reader.EndOfStream)
                {
                    string s = reader.ReadLine();
                    string[] ss = s.Split(new char[] { ' ', '\t' });
                    if (ss.Length > 1)
                    {
                        for (int i = 1; i < ss.Length; i++)
                        {
                            if (ss[i] == "") continue;
                            mMimeTypes[ss[i]] = ss[0];
                        }
                    }
                }
            }
            catch (Exception)
            {

                throw;
            }
            finally
            {
                if (reader != null) reader.Close();
            }


        }

        int WriteBinary(string path, byte[] buffer, FileMode mode)
        {
            int readLimit = buffer.Length;

            BinaryWriter writer = new BinaryWriter(new FileStream(path, mode, FileAccess.Write));
            writer.Write(buffer);
            writer.Close();

            return readLimit;
        }
        byte[] ReadBinary(string path, FileMode mode)
        {
            FileInfo fi = new FileInfo(path);
            if (fi == null) throw new FileNotFoundException();
            if (!fi.Exists) throw new FileNotFoundException();
            BinaryReader reader = new BinaryReader(new FileStream(path, mode, FileAccess.Read));
            long readLimit = fi.Length;
            byte[] buffer = reader.ReadBytes((int)readLimit); //KRIɂQG܂łɂȂĂ܂AȂɓǂ܂ĂB
            reader.Close();

            return buffer;

        }
    }
}
