using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Auth.Model;
using OFW.Auth.Model.Entity;
using OFW.Auth.Model.Property;
using OFW.Database.TableCommand;

namespace OFW.Auth.Model.Access
{
    /// <summary>
    /// AuthUsers ANZX`
    /// </summary>
    [Serializable()]
	public class AuthUsersAccess
	{
        Connection connection;
        /// <summary>
        /// \zB
        /// ڑ͊O炤O
        /// </summary>
        /// <param name="connection"></param>
        public AuthUsersAccess(Connection connection)
        {
            this.connection = connection;
        }
        /// <summary>
        /// w胍OCIDɊY郆[U[擾
        /// </summary>
        /// <param name="loginId">[U[ʂ郍OCID</param>
        /// <returns>w胍OCIDɊY郆[U[B݂Ȃnull</returns>
        public OFW.Auth.Model.Entity.AuthUsersEntity Get(string loginId)
        {
            TableAccess<AuthUsersEntity, AuthUsersProperty> access = new TableAccess<AuthUsersEntity, AuthUsersProperty>(this.connection);
            //key̏
            AuthUsersEntity key = new AuthUsersEntity();
            key.LoginId = loginId;


            AuthUsersEntity entity =  access.Get(key);
            entity.Password = null; ;
            return entity;
        }
        /// <summary>
        /// F؏̌
        /// </summary>
        /// <param name="loginId">[U[ʂ郍OCID</param>
        /// <param name="hashedCredential">Ώۃ[U[LF؏</param>
        /// <returns>ȃ[U[̎True</returns>
        public bool VerifyCredential(string loginId, string hashedCredential)
        {
            AuthUsersProperty property = new AuthUsersProperty();
            TableAccess<AuthUsersEntity, AuthUsersProperty> access = new TableAccess<AuthUsersEntity, AuthUsersProperty>(this.connection);
            ComplexCondition condition = new ComplexCondition();
            condition.AddCondition(new ColumnValueCondition(property.LoginId, loginId, "="));
            condition.AddCondition("AND",new ColumnValueCondition(property.Password, hashedCredential, "="));

            List<AuthUsersEntity> list = access.GetList(condition, null);

            return (list.Count > 0);
        }
    }

}