using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Net;
using System.Web.Services.Protocols;
using System.IO;
using OFW.Util;
using OFW.Database;
using OFW.ErrorHandler;
using OFW.Auth;
using OFW.Serializer;
using OFW.Log;
using System.Reflection;

namespace OFW.Database.DbWebServiceReference
{
    /// <summary>
    /// f[^x[XWebServiceɐڑConnection
    /// </summary>
    public class DbWebServiceReference : OFW.Database.Connection
    {
        OFW.Log.Logger logger = OFW.Log.LoggerFactory.GetLogger("OFW.debug", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.Name);

        DbWebService.DbWebService service;
        System.Net.CookieContainer container;
        string privateKey;

        /// <summary>
        /// ڑJ
        /// </summary>
        /// <param name="isolation">gUNVx</param>
        /// <param name="beginTransaction">gUNVJn邩</param>
        protected override void OpenInternal(IsolationLevel isolation, bool beginTransaction)
        {
            logger.Log(LogLevel.DEBUG, MethodBase.GetCurrentMethod().Name, "start");
            try
            {
                string currentUserId = "nulluser";
                if (this.currentUser == null)
                {
                    Identity id = OFW.Auth.AuthProviderFactory.GetInstance().GetIdentity();
                    if(id != null){
                        currentUserId = id.Name;
                    }
                }
                service = new OFW.Database.DbWebServiceReference.DbWebService.DbWebService();
                service.Url = this.config.Url;
                if (this.config.User != "")
                {
                    service.Credentials = new System.Net.NetworkCredential(this.config.User, this.config.Password);
                }
                container = new System.Net.CookieContainer();
                service.CookieContainer = container;
                this.privateKey = service.Open((int)isolation, beginTransaction,currentUserId);

            }
            catch (SoapException ex)
            {
                throw BuildException(ex,null);
            }
        }
        /// <summary>
        /// ڑ
        /// </summary>
        /// <param name="commitTransaction">ŌɎsĂgUNVR~bg邩B</param>
        protected override void CloseInternal(bool commitTransaction)
        {
            logger.Log(LogLevel.DEBUG, MethodBase.GetCurrentMethod().Name, "start");
            try
            {
                service.Close(commitTransaction);

            }
            catch (SoapException ex)
            {
                throw BuildException(ex, null);
            }
            
        }

        /// <summary>
        /// ₢킹s
        /// </summary>
        /// <param name="command">₢킹command</param>
        /// <param name="timeout">command^CAEg܂ł̎(b)</param>
        /// <returns>₢킹ʂDataSet</returns>
        public override DataSet ExecuteQuery(Command command, int timeout)
        {
            logger.Log(LogLevel.DEBUG, MethodBase.GetCurrentMethod().Name, "start");
            logger.Log(LogLevel.DEBUG, MethodBase.GetCurrentMethod().Name, command);
            try
            {
                string result = service.ExecuteQueryAsSerialized(this.privateKey, this.CopyCommand(command), timeout);
                StringReader reader = new StringReader(result);
                DataSetJSON serializer = new DataSetJSON();
                DataSet resultSet = serializer.DeserializeDataSet(reader) as DataSet;
                return resultSet;
            }
            catch (SoapException ex)
            {
                throw BuildException(ex, command);
            }
            finally
            {
                logger.Debug(MethodBase.GetCurrentMethod().Name, "end");
            }
        }
        /// <summary>
        /// NG[sTableRow̃XgԂ
        /// </summary>
        /// <typeparam name="T">TableRow̌^</typeparam>
        /// <param name="command">NG[R}h</param>
        /// <param name="timeout">commands̃^CAEg</param>
        /// <returns>NG[sʂ̃e[usXg</returns>
        public override List<T> ExecuteQueryAsTableRows<T>(Command command, int timeout) 
        {
            logger.Debug(MethodBase.GetCurrentMethod().Name, "start");
            logger.Debug(MethodBase.GetCurrentMethod().Name, command);
            try
            {
                List<T> list = new List<T>();

                string result = service.ExecuteQueryAsSerialized(this.privateKey, this.CopyCommand(command), timeout);
                StringReader reader = new StringReader(result);
                DataSetJSON serializer = new DataSetJSON();
                DataSet resultSet = serializer.DeserializeDataSet(reader) as DataSet;

                DataRowCollection rows = resultSet.Tables[0].Rows;
                foreach (DataRow row in rows)
                {
                    T data = new T();
                    data.Map(row);
                    list.Add(data);
                }
                return list;
            }
            catch (SoapException ex)
            {
                throw BuildException(ex, command);
            }
            finally
            {
                logger.Debug(MethodBase.GetCurrentMethod().Name, "end");
            }
        }
        /// <summary>
        /// XVs
        /// </summary>
        /// <param name="command">XVNG[R}h</param>
        /// <param name="timeout">commands^CAEg</param>
        /// <returns>s</returns>
        public override int ExecuteUpdate(Command command, int timeout)
        {
            logger.Debug(MethodBase.GetCurrentMethod().Name, "start");
            logger.Debug(MethodBase.GetCurrentMethod().Name, command);
            try
            {
                return service.ExecuteUpdate(this.privateKey, this.CopyCommand(command), timeout);

            }
            catch (SoapException ex)
            {
                throw BuildException(ex, command);
            }
            finally
            {
                logger.Debug(MethodBase.GetCurrentMethod().Name, "end");
            }
        }
        /// <summary>
        /// ÃNG[R}hꊇĎs
        /// </summary>
        /// <param name="commands">R}hz</param>
        /// <param name="timeout">R}h^CAEg</param>
        /// <returns>s</returns>
        public override DataSet ExecuteQueryBatch(Command[] commands, int timeout)
        {
            logger.Debug(MethodBase.GetCurrentMethod().Name, "start");
            foreach(Command c in commands) logger.Debug(MethodBase.GetCurrentMethod().Name, c);

            try
            {
                string result = service.ExecuteQueryBatchAsSerialized(this.privateKey, this.CopyCommandArray(commands), timeout);
                StringReader reader = new StringReader(result);
                DataSetJSON serializer = new DataSetJSON();
                DataSet resultSet = serializer.DeserializeDataSet(reader) as DataSet;
                return resultSet;
            }
            catch (SoapException ex)
            {
                throw BuildException(ex, commands);
            }
            finally
            {
                logger.Debug(MethodBase.GetCurrentMethod().Name, "end");
            }
        }
        /// <summary>
        /// ÃNG[R}hꊇĎs
        /// </summary>
        /// <param name="commands">R}hz</param>
        /// <param name="timeout">R}h^CAEg</param>
        /// <returns>s</returns>
        public override int ExecuteUpdateBatch(Command[] commands, int timeout)
        {
            logger.Debug(MethodBase.GetCurrentMethod().Name, "start");
            foreach (Command c in commands) logger.Debug(MethodBase.GetCurrentMethod().Name, c);

            try
            {
                return service.ExecuteUpdateBatch(this.privateKey, this.CopyCommandArray(commands), timeout);

            }
            catch (SoapException ex)
            {
                throw BuildException(ex, commands);
            }
            finally
            {
                logger.Debug(MethodBase.GetCurrentMethod().Name, "end");
            }
        }
        /// <summary>
        /// gUNVJn
        /// </summary>
        /// <param name="isolation">gUNVx</param>
        protected override void BeginTransactionInternal(System.Data.IsolationLevel isolation)
        {
            logger.Debug(MethodBase.GetCurrentMethod().Name, "start");
            try
            {
                service.BeginTransaction(this.privateKey, (int)isolation);

            }
            catch (SoapException ex)
            {
                throw BuildException(ex, null);
            }
            finally
            {
                logger.Debug(MethodBase.GetCurrentMethod().Name, "end");
            }
        }
        /// <summary>
        /// gUNVm
        /// </summary>
        protected override void CommitTransactionInternal()
        {
            logger.Debug(MethodBase.GetCurrentMethod().Name, "start");
            try
            {
                service.CommitTransaction(this.privateKey);

            }
            catch (SoapException ex)
            {
                throw BuildException(ex);
            }
            finally
            {
                logger.Debug(MethodBase.GetCurrentMethod().Name, "end");
            }
            
        }
        /// <summary>
        /// gUNVj
        /// </summary>
        protected override void RollbackTransactionInternal()
        {
            logger.Debug(MethodBase.GetCurrentMethod().Name, "start");
            try
            {
                service.RollbackTransaction(this.privateKey);

            }
            catch (SoapException ex)
            {
                throw BuildException(ex);
            }
            finally
            {
                logger.Debug(MethodBase.GetCurrentMethod().Name, "end");
            }
        }
        /// <summary>
        /// NG[R}hscommand𐶐
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        protected override System.Data.Common.DbCommand CreateDbCommand(Command command)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        /// <summary>
        /// ̐ڑŎgpłDataAdapter𐶐
        /// </summary>
        /// <returns></returns>
        protected override System.Data.Common.DbDataAdapter CreateDataAdapter()
        {
            throw new Exception("The method or operation is not implemented.");
        }
        /// <summary>
        /// VXeԎ擾
        /// </summary>
        /// <returns></returns>
        public override DateTime SystemDate()
        {
            return service.SystemDate(this.privateKey);
        }
        /// <summary>
        /// R}hwebT[rXpɃRs[
        /// </summary>
        /// <param name="command">̃R}h</param>
        /// <returns>webT[rXpR}h</returns>
        string CopyCommand(Command command)
        {
            System.Xml.Serialization.XmlSerializer ser = new System.Xml.Serialization.XmlSerializer(command.GetType());
            System.IO.StringWriter writer = new System.IO.StringWriter();
            ser.Serialize(writer, command);
            writer.Close();
            return writer.ToString();
        }
        /// <summary>
        /// R}hwebT[rXpɃRs[
        /// </summary>
        /// <param name="command">̃R}h</param>
        /// <returns>webT[rXp</returns>
        string CopyCommandArray(Command[] command)
        {
            System.Xml.Serialization.XmlSerializer ser = new System.Xml.Serialization.XmlSerializer(command.GetType());
            System.IO.StringWriter writer = new System.IO.StringWriter();
            ser.Serialize(writer, command);
            writer.Close();
            return writer.ToString();
        }
        /// <summary>
        /// ŌIdentity
        /// </summary>
        /// <returns></returns>
        public override int GetLastIdentity()
        {
            throw new Exception("The method or operation is not implemented.");
        }

        /// <summary>
        /// NbL[̃fobOp\
        /// </summary>
        void DumpCookies()
        {
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "dump cookies:");
            CookieCollection cookies = container.GetCookies(new Uri(this.service.Url));
            foreach (Cookie c in cookies)
            {
                logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, c.Name + " = " + c.Value);
            }
        }
        /// <summary>
        /// ݂̐ڑɑΉO𐶐
        /// ł͎gpłȂ(ڑ悪WebServiceȂ̂DbExceptionEȂ)̂ŎgOo
        /// </summary>
        /// <param name="ex">DBO</param>
        /// <param name="commands">݂command</param>
        /// <returns>݂̐ڑɑΉO</returns>
        protected override ConnectionException BuildException(System.Data.Common.DbException ex, params Command[] commands)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        /// <summary>
        /// ݂̐ڑɑΉO𐶐
        /// ڑ悪WebServiceȂ̂ŁASoapExceptionDetail烁bZ[W擾č\zȂ
        /// </summary>
        /// <param name="ex">SoapO</param>
        /// <param name="commands">݂command</param>
        /// <returns>݂̐ڑɑΉO</returns>
        protected ConnectionException BuildException(System.Web.Services.Protocols.SoapException ex, params Command[] commands)
        {
            System.Xml.XmlNode rootNode = ex.Detail;
            
            //Detail"exception"vf=JX^OKv
            if (OFW.Util.XmlUtil.NodeExists(rootNode, "exception"))
            {
                string exceptionType = OFW.Util.StringUtil.StringValue(OFW.Util.XmlUtil.GetText(rootNode, "exception/type"));
                string message = OFW.Util.StringUtil.StringValue(OFW.Util.XmlUtil.GetText(rootNode, "exception/message"));

                //̗OڑOȂ(܂WebServiceŃf[^x[XG[Ȃ)e擾ConnectionException蒼
                if (exceptionType.Equals(typeof(OFW.Database.ConnectionException).FullName))
                {
                    int errorNumber = OFW.Util.NumberUtil.Value<int>(OFW.Util.XmlUtil.GetText(rootNode, "exception/errorNumber"));
                    byte state = OFW.Util.NumberUtil.Value<byte>(OFW.Util.XmlUtil.GetText(rootNode, "exception/state"));
                    string server = OFW.Util.StringUtil.StringValue(OFW.Util.XmlUtil.GetText(rootNode, "exception/server"));
                    string procedure = OFW.Util.StringUtil.StringValue(OFW.Util.XmlUtil.GetText(rootNode, "exception/procedure"));
                    int lineNumber = OFW.Util.NumberUtil.Value<int>(OFW.Util.XmlUtil.GetText(rootNode, "exception/lineNumber"));


                    return new ConnectionException(message,
                        errorNumber,
                        state,
                        server,
                        procedure,
                        lineNumber,
                        commands
                    );
                }
                //webserviceŉO悤ƂÂ܂ܖ߂ĂB
                return new ConnectionException(message, -1, commands);
            }
            //̑SOAPOcp[^G[ƂVACYG[ƂÂ͂
            return new ConnectionException(ex.Message);
        }
    }
}
