using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;

using ODP = Oracle.DataAccess.Client;
using ODPTypes = Oracle.DataAccess.Types;

namespace OFW.Database.Oracle
{
    public class OracleParameter : OFW.Database.Parameter
    {
        private ODP.OracleDbType odpType;
        /// <summary>
        /// p[^^Cv
        /// </summary>
        public ODP.OracleDbType OdpType
        {
            get { return odpType; }
            set { odpType = value; }
        }

        /// <summary>
        /// \z(ftHg)
        /// </summary>
        public OracleParameter()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="name">p[^</param>
        public OracleParameter(string name)
        {
            this.parameterName = name;
            this.length = 0;
            this.precision = 0;
            this.scale = 0;
            this.parameterValue = null;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="name">p[^</param>
        /// <param name="paramType"></param>
        public OracleParameter(string name, ODP.OracleDbType paramType)
        {
            this.parameterName = name;
            this.OdpType = paramType;
            this.length = 0;
            this.precision = 0;
            this.scale = 0;
            this.parameterValue = null;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="name">p[^</param>
        /// <param name="paramType"></param>
        /// <param name="value">p[^ɐݒ肷l</param>
        public OracleParameter(string name, ODP.OracleDbType paramType, object value)
        {
            this.parameterName = name;
            this.odpType = paramType;
            this.length = 0;
            this.precision = 0;
            this.scale = 0;
            this.parameterValue = value;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="name">p[^</param>
        /// <param name="value">p[^ɐݒ肷l</param>
        public OracleParameter(string name,  object value)
        {
            this.parameterName = name;
            this.length = 0;
            this.precision = 0;
            this.scale = 0;
            this.parameterValue = value;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="name">p[^</param>
        /// <param name="paramType"></param>
        /// <param name="value">p[^ɐݒ肷l</param>
        /// <param name="len"></param>
        public OracleParameter(string name, ODP.OracleDbType paramType, object value, int len)
        {
            this.parameterName = name;
            this.odpType = paramType;
            this.length = len;
            this.precision = 0;
            this.scale = 0;
            this.parameterValue = value;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="name">p[^</param>
        /// <param name="paramType"></param>
        /// <param name="value">p[^ɐݒ肷l</param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        public OracleParameter(string name, ODP.OracleDbType paramType, object value, int precision, int scale)
        {
            this.parameterName = name;
            this.odpType = paramType;
            this.length = 0;
            this.precision = precision;
            this.scale = scale;
            this.parameterValue = value;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="property">̃p[^Ɋ蓖Ă^vpeB</param>
        public OracleParameter(FieldProperties.FieldProperty property)
        {
            this.parameterName = "@" + property.FieldName;
            this.parameterType = property.SqlType();
            this.length = property.Length;
            this.precision = property.Precision;
            this.scale = property.Scale;
            this.parameterValue = null;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="property">̃p[^Ɋ蓖Ă^vpeB</param>
        /// <param name="value">p[^ɐݒ肷l</param>
        public OracleParameter(FieldProperties.FieldProperty property, object value)
        {
            this.parameterName = "@" + property.FieldName;
            this.parameterType = property.SqlType();
            this.length = property.Length;
            this.precision = property.Precision;
            this.scale = property.Scale;
            this.parameterValue = value;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="name">p[^</param>
        /// <param name="property">̃p[^Ɋ蓖Ă^vpeB</param>
        /// <param name="value">p[^ɐݒ肷l</param>
        public OracleParameter(string name, FieldProperties.FieldProperty property, object value)
        {
            this.parameterName = name;
            this.parameterType = property.SqlType();
            this.length = property.Length;
            this.precision = property.Precision;
            this.scale = property.Scale;
            this.parameterValue = value;
            this.parameterDirection = ParameterDirection.Input;
        }
        /// <summary>
        /// Rs[\z
        /// </summary>
        /// <param name="p"></param>
        public OracleParameter(Parameter p)
        {
            this.parameterName = p.ParameterName;
            this.parameterType = p.ParameterType;
            this.length = p.Length;
            this.precision = p.Precision;
            this.scale = p.Scale;
            this.parameterValue = p.ParameterValue;
            this.parameterDirection = p.ParameterDirection;
        }

        public ODP.OracleParameter toOdpParameter()
        {
            ODP.OracleParameter odpParamter = new ODP.OracleParameter();

            odpParamter.ParameterName = ParameterName;
            odpParamter.OracleDbType = OdpType;
            odpParamter.Size = Length;
            odpParamter.Precision = (byte)Precision;
            odpParamter.Scale = (byte)Scale;
            odpParamter.Value = ParameterValue;
            odpParamter.Direction = ParameterDirection;

            return odpParamter;

        }

    }
}
