using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Database.Expressions;

namespace OFW.Database.CommandBuilder
{
    /// <summary>
    /// e[uf[^XVR}h
    /// </summary>
    public class DeleteCommandBuilder : CommandBuilderBase
    {
        /// <summary>
        /// e[u
        /// </summary>
        private string targetTable;

        #region constructors
        /// <summary>
        /// e[uփf[^ǉR}h
        /// </summary>
        public DeleteCommandBuilder(Connection connection)
            : base()
        {
            this.connection = connection;
            targetTable = "";
        }

        #endregion
        /// <summary>
        /// 폜e[uw肷
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public DeleteCommandBuilder from(string tableName)
        {
            targetTable = tableName;
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public DeleteCommandBuilder where(Expression cond)
        {
            criteria.AddWhere(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public DeleteCommandBuilder whereAnd(Expression cond)
        {
            criteria.AddWhereAnd(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public DeleteCommandBuilder whereOr(Expression cond)
        {
            criteria.AddWhereOr(cond);
            return this;
        }

        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override void buildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("DELETE FROM " + targetTable );

            if (criteria.whereExpression != "")
            {
                b.Append(" WHERE " + criteria.whereExpression);
            }


            query = b.ToString();
        }

    }
}
