using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Database.Expressions;

namespace OFW.Database.CommandBuilder
{
    /// <summary>
    /// e[uփf[^ǉR}h
    /// </summary>
    public class InsertCommandBuilder : CommandBuilderBase
    {
        /// <summary>
        /// e[u
        /// </summary>
        private string targetTable;
        /// <summary>
        /// J
        /// </summary>
        private StringBuilder columnsBuilder;
        private StringBuilder valuesBuilder;

        #region constructors
        /// <summary>
        /// e[uփf[^ǉR}h
        /// </summary>
        public InsertCommandBuilder(Connection connection) : base()
        {
            this.connection = connection;
            columnsBuilder = new StringBuilder();
            valuesBuilder = new StringBuilder();
            targetTable = "";

        }
        #endregion
        /// <summary>
        /// ǉe[uݒ肷
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public InsertCommandBuilder into(string tableName)
        {
            targetTable = tableName;
            return this;

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="property"></param>
        /// <param name="value"></param>
        public InsertCommandBuilder insert(FieldProperties.FieldProperty property, object value)
        {
            if (columnsBuilder.Length > 0) columnsBuilder.Append(",");
            if (valuesBuilder.Length > 0) valuesBuilder.Append(",");

            columnsBuilder.Append(connection.QuoteIdentifier(property.FieldName));

            string parameterName = connection.buildParameterName( property.FieldName );
            valuesBuilder.Append(parameterName);

            Parameter param = new Parameter(parameterName, property.SqlType(), value);
            param.Length = property.Length;
            param.Precision = property.Precision;
            param.Scale = property.Scale;

            parameters.Add(param);
            return this;


        }

        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public InsertCommandBuilder where(Expression cond)
        {
            criteria.AddWhere(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public InsertCommandBuilder whereAnd(Expression cond)
        {
            criteria.AddWhereAnd(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public InsertCommandBuilder whereOr(Expression cond)
        {
            criteria.AddWhereOr(cond);
            return this;
        }

        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override void buildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("INSERT INTO " + targetTable );
            b.Append(" ( " + columnsBuilder.ToString() + " )");
            b.Append(" VALUES ( " + valuesBuilder.ToString() + " )");

            if (criteria.whereExpression != "")
            {
                b.Append(" WHERE " + criteria.whereExpression);
            }


            query = b.ToString();
        }

    }
}
