using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;


namespace OFW.Database.Conditions
{
    /// <summary>
    /// 𕶎Ŏw肷
    /// </summary>
    public class StringCondition : Expressions.Expression
    {

        #region constructors
        /// <summary>
        /// ftHg
        /// </summary>
        public StringCondition() : base()
        {
            builtExpression = "";
        }
        /// <summary>
        /// ݒ
        /// </summary>
        /// <param name="exp"></param>
        public StringCondition(string exp) : base()
        {
            builtExpression = exp;
        }
        /// <summary>
        /// Ap[^ݒ
        /// </summary>
        /// <param name="exp"></param>
        /// <param name="paramName">p[^</param>
        /// <param name="property">vpeB</param>
        /// <param name="value">l</param>
        public StringCondition(string exp, string paramName, FieldProperty property, object value)
            : base()
        {
            builtExpression = exp;

            Parameter p = new Parameter(paramName, property.SqlType(), value);
            p.Length = property.Length;
            p.Precision = property.Precision;
            p.Scale = property.Scale;
            parameters.Add(p);
        }
        /// <summary>
        /// Ap[^ݒ
        /// </summary>
        /// <param name="exp"></param>
        /// <param name="paramName">p[^</param>
        /// <param name="type">^</param>
        /// <param name="value">l</param>
        public StringCondition(string exp, string paramName, DbType type, object value) :base()
        {
            builtExpression = exp;
            parameters = new List<Parameter>();

            Parameter p = new Parameter(paramName, type,value);
            parameters.Add(p);
        }
        /// <summary>
        /// Ap[^ݒ
        /// </summary>
        /// <param name="exp"></param>
        /// <param name="paramName">p[^</param>
        /// <param name="value">l</param>
        public StringCondition(string exp, string paramName, object value) : base()
        {
            builtExpression = exp;
            parameters = new List<Parameter>();

            Parameter p = new Parameter(paramName,value);
            parameters.Add(p);
        }
        /// <summary>
        /// Ap[^ݒ
        /// </summary>
        /// <param name="exp"></param>
        /// <param name="parameters">p[^</param>
        public StringCondition(string exp, IEnumerable<Parameter> parameters) : base()
        {
            builtExpression = exp;
            parameters = new List<Parameter>();

            this.parameters.AddRange(parameters);
        }

        #endregion
        /// <summary>
        /// ̏킷̕
        /// </summary>
        /// <returns>̏킷̕</returns>
        public string BuildExpression()
        {
            return builtExpression;
        }
        /// <summary>
        /// ̏ɐݒ肳ꂽp[^
        /// </summary>
        /// <returns>̏ɐݒ肳ꂽp[^</returns>
        public List<Parameter> GetParameters()
        {
            return parameters;
        }
        /// <summary>
        /// gݗĂ
        /// </summary>
        /// <remarks>ۂɂ͑gݗčς݂̎nĂ͂Ȃ̂ŉȂ</remarks>
        public override void buildExpression()
        {
        }

    }
}
