using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using OFW.Database.Expressions;
using OFW.FieldProperties;
namespace OFW.Database
{
    /// <summary>
    /// f[^\
    /// </summary>
    /// <remarks>f[^ɎgpWhere,OrderBy,GroupByȂǂꊇĎ舵B
    /// </remarks>
    /// <example>
    /// <code>
    ///        OFW.Database.Criteria c = new OFW.Database.Criteria();
    ///
    ///        c.AddWhere(new ColumnValueCondition(field1, 1, ">="));
    ///        c.AddWhere(new ColumnValueCondition(field1, 10, "&lt;="));
    ///        c.AddWhereOr(new ColumnValueCondition(field1, 100, "&lt;="));
    ///        c.AddWhereOr(new ColumnValueCondition(field2, "101010101", "="));
    ///        c.AddWhereOr(new ColumnValueCondition(field2, new string[] { "10", "20" }, "IN"));
    ///        c.AddOrderBy(field2);
    ///        c.AddOrderBy(field3,"DESC");
    ///
    ///        c.assemble();
    ///
    ///        string where = c.whereExpression;
    ///        string orderBy = c.orderByExpression;
    ///        string having = c.havingByExpression;
    ///        string groupBy = c.broupByExpression;
    /// </code>
    /// </example>
    public class Criteria
    {
        /// <summary>
        /// 
        /// </summary>
        private  List<Expression> whereList;

        /// <summary>
        /// 
        /// </summary>
        private List<String> orderByList;
        private List<String> orderByDirections;
        /// <summary>
        /// O[v
        /// </summary>
        private List<String> groupByList;
        /// <summary>
        /// O[v̐
        /// </summary>
        private List<Expression> havingList;
        /// <summary>
        /// p[^Xg
        /// </summary>
        public List<Parameter> parameters;
        /// <summary>
        /// WHEREɎg
        /// </summary>
        public string whereExpression;
        /// <summary>
        /// ORDER BYɎg
        /// </summary>
        public string orderByExpression;
        /// <summary>
        /// GROUP BYɎg
        /// </summary>
        public string groupByExpression;
        /// <summary>
        /// HAVINGɎg
        /// </summary>
        public string havingExpression;
        /// <summary>
        /// (SQLT[o[)ݒ肳ꂽorderby̋t̎
        /// </summary>
        public string reverseOrderByExpression;

        /// <summary>
        /// Jnʒu
        /// </summary>
        public int offset = -1;
        /// <summary>
        /// 擾̐
        /// </summary>
        public int limit = 0;


        /// <summary>
        /// assemblê߂̃IvV
        /// </summary>
        public enum AssembleOption
        {
            /// <summary>
            /// optionȂ
            /// </summary>
            NONE = 0,
            /// <summary>
            /// tނ̏𓯎ɍBSQL Server2005OSqlServerlimit,offsetgȂׂHack
            /// </summary>
            WITH_ORDER_BY_REVERSE = 1
        }
        /// <summary>
        /// {Iȍ\z
        /// </summary>
        public Criteria() : base()
        {
            this.whereList = new List<Expression>();
            this.groupByList = new List<String>();
            this.orderByDirections = new List<String>();
            this.orderByList = new List<String>();
            this.havingList = new List<Expression>();

            this.parameters = new List<Parameter>();

            whereExpression = "";
            groupByExpression = "";
            orderByExpression = "";
            havingExpression = "";
            reverseOrderByExpression = "";
        }
        /// <summary>
        /// WHEREǉ ftHg AND
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhere(Expression condition)
        {

            if (this.whereList.Count > 0) whereList.Add(Operator.create("AND"));
            this.whereList.Add(condition);
        }
        /// <summary>
        /// WHEREǉ AND
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereAnd(Expression condition)
        {

            if (this.whereList.Count > 0) whereList.Add(Operator.create("AND"));
            this.whereList.Add(condition);
        }
        /// <summary>
        /// WHEREǉ OR
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereOr(Expression condition)
        {
            if (this.whereList.Count > 0) whereList.Add(Operator.create("OR"));
            this.whereList.Add(condition);
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="property">Ɏw肷`</param>
        public void AddOrderBy(FieldProperties.FieldProperty property)
        {
            this.orderByList.Add(property.FullName() );
            this.orderByDirections.Add( "ASC" );

        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="property">Ɏw肷`</param>
        /// <param name="direction">̕(ASC|DESC)</param>
        public void AddOrderBy(FieldProperties.FieldProperty property,string direction)
        {
            this.orderByList.Add(property.FullName());
            this.orderByDirections.Add(direction);

        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="columnName">Ɏw肷̖OA邢͗̎(SUM(hoge)̂悤Ȏ)</param>
        public void AddOrderBy(string columnName)
        {
            this.orderByList.Add(columnName);
            this.orderByDirections.Add("ASC");

        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="columnName">Ɏw肷̖OA邢͗̎(SUM(hoge)̂悤Ȏ)</param>
        /// <param name="direction">̕(ASC|DESC)</param>
        public void AddOrderBy(string columnName, string direction)
        {
            this.orderByList.Add(columnName);
            this.orderByDirections.Add(direction);

        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="property">O[v̒`</param>
        public void AddGroupBy(FieldProperties.FieldProperty property)
        {
            this.groupByList.Add(property.FullName());

        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="column">O[v̒`</param>
        public void AddGroupBy(string column)
        {
            this.groupByList.Add(column);

        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddHaving(Expression condition)
        {

            if (this.havingList.Count > 0) havingList.Add(Operator.create("AND"));
            this.havingList.Add(condition);
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddHavingAnd(Expression condition)
        {

            if (this.havingList.Count > 0) havingList.Add(Operator.create("AND"));
            this.havingList.Add(condition);
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddHavingOr(Expression condition)
        {


            if (this.havingList.Count > 0) havingList.Add(Operator.create("OR"));
            this.havingList.Add(condition);
        }
        /// <summary>
        /// SĂ̎K
        /// </summary>
        public void assemble()
        {
            assemble(AssembleOption.NONE);
        }
        /// <summary>
        /// SĂ̎K
        /// </summary>
        public void assemble(AssembleOption option)
        {
            this.parameters = new List<Parameter>();
            if (this.whereList.Count > 0)
            {
                whereExpression = BuildWhere();

            }
            if (this.orderByList.Count > 0)
            {
                orderByExpression = BuildOrderBy();
                if (option == AssembleOption.WITH_ORDER_BY_REVERSE)
                {
                    reverseOrderByExpression = BuildReverseOrderBy();
                }
            }
            if (this.groupByList.Count > 0)
            {
                groupByExpression = BuildGroupBy();
            }
            if (this.havingList.Count > 0)
            {
                havingExpression = BuildHaving();
            }
        }
        /// <summary>
        /// SQL
        /// </summary>
        private void BuildQuery()
        {
            if (this.whereList.Count > 0)
            {
                whereExpression = BuildWhere();

            }
            if (this.orderByList.Count > 0)
            {
                orderByExpression = BuildOrderBy();
            }
            if (this.groupByList.Count > 0)
            {
                groupByExpression = BuildGroupBy();
            }
            if (this.havingList.Count > 0)
            {
                havingExpression = BuildHaving();
            }
        }
        /// <summary>
        /// where\z
        /// </summary>
        /// <returns></returns>
        private string BuildWhere()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.whereList.Count; i++)
            {
                Expression cond = this.whereList[i];
                cond.buildExpression();
                b.Append(cond.getExpression());
                this.parameters.AddRange(cond.getParameters());
            }
            return b.ToString();
        }
        /// <summary>
        ///  \z
        /// </summary>
        /// <returns>ORDER BY</returns>
        private string BuildOrderBy()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.orderByList.Count; i++)
            {
                if (i > 0) b.Append(",");
                b.Append(this.orderByList[i]);
                b.Append(" " + this.orderByDirections[i]);


            }
            return b.ToString();
        }
        /// <summary>
        /// t \z
        /// </summary>
        /// <returns>ORDER BYɎǵutv</returns>
        /// <remarks>炭SQLT[o[łgȂ(y[WO@\̂)Bf[^\[Xڎg</remarks>
        private string BuildReverseOrderBy()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.orderByList.Count; i++)
            {
                if (i > 0) b.Append(",");
                b.Append(this.orderByList[i]);
                
                b.Append( " " + (this.orderByDirections[i] == "DESC" ? "ASC":"DESC"));

            }
            return b.ToString();
        }
        /// <summary>
        /// O[v\z
        /// </summary>
        /// <returns>GROUP BY</returns>
        private string BuildGroupBy()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.groupByList.Count; i++)
            {
                if (i > 0) b.Append(",");
                b.Append(this.groupByList[i]);

            }
            return b.ToString();
        }
        /// <summary>
        /// O[v \z
        /// </summary>
        /// <returns>HAVING</returns>
        private string BuildHaving()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.havingList.Count; i++)
            {
                Expression cond = this.havingList[i];
                cond.buildExpression();
                b.Append(cond.getExpression());
                this.parameters.AddRange(cond.getParameters());


            }
            return b.ToString();
        }

        #region by method chain
        /// <summary>
        /// 
        /// </summary>
        /// <param name="condition"></param>
        /// <returns></returns>
        public Criteria where(params Expression[] condition)
        {
            foreach (Expression c in condition)
            {
                this.AddWhere(c);
            }
            return this;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="condition"></param>
        /// <returns></returns>
        public Criteria where(Expression condition)
        {
            this.AddWhere(condition);
            return this;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="condition"></param>
        /// <returns></returns>
        public Criteria whereAnd(Expression condition)
        {
            this.AddWhereAnd(condition);
            return this;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="condition"></param>
        /// <returns></returns>
        public Criteria whereOr(Expression condition)
        {
            this.AddWhereOr(condition);
            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="property">Ɏw肷`</param>
        public Criteria orderBy(params FieldProperties.FieldProperty[] property)
        {
            foreach (FieldProperty p in property)
            {
                AddOrderBy(p);
            }

            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="property">Ɏw肷`</param>
        public Criteria orderBy(FieldProperties.FieldProperty property)
        {
            AddOrderBy(property);

            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="property">Ɏw肷`</param>
        /// <param name="direction">̕(ASC|DESC)</param>
        public Criteria orderBy(FieldProperties.FieldProperty property, string direction)
        {
            AddOrderBy(property,direction);

            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="columns"></param>
        public Criteria orderBy(params string[] columns)
        {
            foreach (string column in columns)
            {
                AddOrderBy(column);
            }

            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="columnName">Ɏw肷̖OA邢͗̎(SUM(hoge)̂悤Ȏ)</param>
        public Criteria orderBy(string columnName)
        {
            AddOrderBy(columnName);

            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="columnName">Ɏw肷̖OA邢͗̎(SUM(hoge)̂悤Ȏ)</param>
        /// <param name="direction">̕(ASC|DESC)</param>
        public Criteria orderBy(string columnName, string direction)
        {
            AddOrderBy(columnName,direction);

            return this;
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="properties">O[v̒`</param>
        public Criteria groupBy(params FieldProperty[] properties)
        {
            foreach (FieldProperty p in properties)
            {
                AddGroupBy(p);
            }

            return this;
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="property">O[v̒`</param>
        public Criteria groupBy(FieldProperties.FieldProperty property)
        {
            AddGroupBy(property);

            return this;
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="columns">O[v̒`</param>
        public Criteria groupBy(params string[] columns)
        {
            foreach (string c in columns)
            {
                AddGroupBy(c);
            }

            return this;
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="column">O[v̒`</param>
        public Criteria groupBy(string column)
        {
            this.groupByList.Add(column);

            return this;
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public Criteria having(Expression condition)
        {
            AddHaving(condition);
            return this;
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public Criteria havingAnd(Expression condition)
        {

            AddHavingAnd(condition);
            
            return this;
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public Criteria havingOr(Expression condition)
        {
            AddHavingOr(condition);

            return this;
        }

        #endregion
    }
}
