using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using OFW.Util;
using OFW.FieldProperties;

namespace OFW.Database.Expressions
{
    /// <summary>
    /// Ƃ̒lw肷BƂ COLUMN1 = @parameter ̂悤Ȏ\B
    /// </summary>
    /// <remarks> COLUMN1 = @parameter ̂悤Ȏ𐶐Ap[^B<p>LIKEgpꍇ͕ʓrConnection#EscapeWildCardsʂ"%","_"KXlvalueɎw肷B</p></remarks>
    /// <example>"="Ŕr鎮
    /// <code>SampleEntityProperty entityProperty = new SampleEntityProperty();
    /// Expression expr = new ColumnValueCondition(entityProperty.field1,10);
    /// </code>
    /// CriteriaɈA̎ǉBł͑SANDŌB
    /// <code>Connection connection = ConnectionFactory.getConnectionByName(); //nameȗ"default"g
    /// SampleEntityProperty entityProperty = new SampleEntityProperty();
    /// Criteria c = new Criteria();
    /// //P "="r
    /// c.where(new ColumnValueCondition(entityProperty.field1,10));
    /// //LIKEgB"%","_"Ȃǂ̓ChJ[hɂȂ̂ł炩߃GXP[vKvB
    /// //̏ꍇA"100%"ŊJn镶Ƀ}b`B
    /// //(ŃGXP[vƂ̏ꍇ "100"Ƀ}b`鎮oȂȂ )
    /// c.where(new ColumnValueCondition(entityProperty.field2,connection.EscapeWildCards("100%") + "%","LIKE"));
    /// //BETWEENgBrvf͔zœnB(List&lt;int&gt;łǂ)
    /// c.where(new ColumnValueCondition(entityProperty.field3,new int[]{ 10,20 },"BETWEEN"));
    /// //p[^w肷Bɑ΂rKvȏꍇɎg
    /// c.where(new ColumnValueCondition(entityProperty.field4,80,">=","@field4_lower"));
    /// c.where(new ColumnValueCondition(entityProperty.field4,100,">=","@field4_upper"));
    /// Expression expr = new ColumnValueCondition(entityProperty.field1,10);
    /// </code>
    /// </example>
    public class ColumnValueCondition : Expression
    {
        /// <summary>
        /// ̕\
        /// </summary>
        string columnExpression;
        /// <summary>
        /// ֘AZq
        /// </summary>
        string relationalOperator;
        /// <summary>
        /// \zB"TABLE1.COLUMN1 = @TABLE1__COLUMN1" ȂǏ"="ݒ肷B
        /// </summary>
        /// <param name="p">ݒ肵FieldPropertyCX^XBΏۗ̃e[uɕʖ悤ȏꍇp.TableNameύXĂAEntityPropertyAliasύXB</param>
        /// <param name="value">rΏۂ̒lBBETWEEN,IN,NOT INȂǔrΏƂKvȏꍇ̓Xg܂͔zŎw肷B</param>
        public ColumnValueCondition(FieldProperty p, object value)
            : base()
        {

            string parameterName = "@" + p.Alias();
            this.columnExpression = p.FullName();
            this.relationalOperator = Expression.EQUAL;
            this.parameters = new List<Parameter>();
            if (value is string)
            {
                addSingleParameter(parameterName, value, p);
            }
            else if (value is IEnumerable)
            {
                addMultuParameter(parameterName, (IEnumerable)value, p);
            }
            else
            {
                addSingleParameter(parameterName, value, p);
            }
        }
        /// <summary>
        /// \zB"TABLE1.COLUMN1 &lt;= @TABLE1__COLUMN1" Ȃǎw肳ꂽ֌WZqgĔrB
        /// </summary>
        /// <param name="p">ݒ肵FieldPropertyCX^XBΏۗ̃e[uɕʖ悤ȏꍇp.TableNameύXĂAEntityPropertyAliasύXB</param>
        /// <param name="value">rΏۂ̒lBBETWEEN,IN,NOT INȂǔrΏƂKvȏꍇ̓Xg܂͔zŎw肷B</param>
        /// <param name="relationalOperator">֌WZqB"=","&lt;",">"Ȃǂw肷B</param>
        public ColumnValueCondition(FieldProperty p, object value, string relationalOperator)
            : base()
        {
            
            string parameterName = "@" +  p.Alias();
            this.columnExpression = p.FullName();
            this.relationalOperator = relationalOperator.ToUpper();
            this.parameters = new List<Parameter>();
            if (value is string)
            {
                addSingleParameter(parameterName, value, p);
            }
            else if (value is IEnumerable)
            {
                addMultuParameter(parameterName, (IEnumerable)value, p);
            }
            else
            {
                addSingleParameter(parameterName, value, p);
            }
        }
        /// <summary>
        /// p[^w肷\zBɑ΂rKvɂȂꍇȂǁB
        /// </summary>
        /// <param name="p">ݒ肵FieldPropertyCX^XBΏۗ̃e[uɕʖ悤ȏꍇp.TableNameύXĂAEntityPropertyAliasύXB</param>
        /// <param name="value">rl</param>
        /// <param name="relationalOperator">֌WZq</param>
        /// <param name="parameterName">p[^B̃p[^ƂԂȂOKv(p[^݂̂T|[gꍇ̓NG[sɂ͎gpȂAR}h̃_vȂǂŁuǂ̃p[^̒lȂ̂v킩₷ׂɕKv)</param>
        public ColumnValueCondition(FieldProperty p, object value, string relationalOperator,string parameterName) : base()
        {
            this.columnExpression = p.FullName();
            this.relationalOperator = relationalOperator.ToUpper();
            this.parameters = new List<Parameter>();
            if (value is string)
            {
                addSingleParameter( parameterName,value,p );
            }
            else if (value is IEnumerable)
            {
                addMultuParameter(parameterName, (IEnumerable)value, p);
            }
            else
            {
                addSingleParameter(parameterName, value, p);
            }
        }
        /// <summary>
        /// 񖼂𒼐ڎw肷\zB֌WZq"="
        /// </summary>
        /// <param name="columnExperssion"></param>
        /// <param name="value">rl</param>
        public ColumnValueCondition(string columnExperssion, object value)
            : base()
        {
            string parameterName = columnExperssion;
            this.columnExpression = columnExperssion;
            this.relationalOperator = Expression.EQUAL;
            this.parameters = new List<Parameter>();
            if (value is string)
            {
                addSingleParameter(parameterName, value);
            }
            else if (value is IEnumerable)
            {
                addMultuParameter(parameterName, (IEnumerable)value);
            }
            else
            {
                addSingleParameter(parameterName, value);
            }
        }
        /// <summary>
        /// 񖼂𒼐ڎw肷\zB
        /// </summary>
        /// <param name="columnExperssion"></param>
        /// <param name="value">rl</param>
        /// <param name="relationalOperator">Zq</param>
        public ColumnValueCondition(string columnExperssion, object value, string relationalOperator)
            : base()
        {
            string parameterName = columnExperssion;
            this.columnExpression = columnExperssion;
            this.relationalOperator = relationalOperator.ToUpper();
            this.parameters = new List<Parameter>();
            if (value is string)
            {
                addSingleParameter(parameterName, value);
            }
            else if (value is IEnumerable)
            {
                addMultuParameter(parameterName, (IEnumerable)value);
            }
            else
            {
                addSingleParameter(parameterName, value);
            }
        }

        /// <summary>
        /// 񖼂𒼐ڎw肷\zB
        /// </summary>
        /// <param name="columnExperssion"></param>
        /// <param name="value">rl</param>
        /// <param name="relationalOperator">Zq</param>
        /// <param name="parameterName">p[^</param>
        public ColumnValueCondition(string columnExperssion, object value, string relationalOperator, string parameterName)
            : base()
        {
            this.columnExpression = columnExperssion;
            this.relationalOperator = relationalOperator.ToUpper();
            this.parameters = new List<Parameter>();
            if (value is string)
            {
                addSingleParameter(parameterName, value );
            }
            else if (value is IEnumerable)
            {
                addMultuParameter(parameterName, (IEnumerable)value );
            }
            else
            {
                addSingleParameter(parameterName, value);
            }
        }

        void addMultuParameter(string parameterName, IEnumerable values, FieldProperty p)
        {
            int i = 0;
            foreach (object value in values)
            {
                addSingleParameter(parameterName + "_" + i.ToString(), value, p);
                i++;
            }
        }
        void addSingleParameter(string parameterName, object value, FieldProperty p)
        {
            Parameter parameter = new Parameter(parameterName, p, value);
            parameters.Add(parameter);
        }
        void addMultuParameter(string parameterName, IEnumerable values)
        {
            int i = 0;
            foreach (object value in values)
            {
                addSingleParameter(parameterName + "_" + i.ToString(), value);
                i++;
            }
        }
        void addSingleParameter(string parameterName, object value)
        {
            Parameter parameter = new Parameter(parameterName, value);
            parameters.Add(parameter);
        }

        /// <summary>
        /// \z 
        /// </summary>
        /// <returns></returns>
        public override void buildExpression()
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(columnExpression);
            builder.Append(" ");
            builder.Append(relationalOperator);
            builder.Append(" ");
            if (relationalOperator == Expression.BETWEEN)
            {
                buildBetweenValueExpression(builder);
            }
            else if (relationalOperator == Expression.IN || relationalOperator == Expression.NOT_IN)
            {
                buildInValueExpression(builder);
            }
            else
            {
                buildDefaultValueExperssion(builder);
            }

            builtExpression = builder.ToString(); 
        }
        
        void buildBetweenValueExpression(StringBuilder builder)
        {
            builder.Append(parameters[0].ParameterName);
            builder.Append(" AND ");
            builder.Append(parameters[1].ParameterName);
        }
        void buildInValueExpression(StringBuilder builder)
        {
            builder.Append("(");
            for (int i = 0; i < parameters.Count; i++)
            {
                if(i > 0) builder.Append(",");
                builder.Append(parameters[i].ParameterName);
            }

            builder.Append(")");
        }
        void buildDefaultValueExperssion(StringBuilder builder)
        {
            builder.Append(parameters[0].ParameterName);
        }
    }
}
