using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;

namespace CFW.common.tableCommand
{
    /// <summary>
    /// table command 
    /// </summary>
    public abstract class TableCommand
    {
        /// <summary>
        /// Ώۂ̃e[uB
        /// </summary>
        public string TableName;
        /// <summary>
        /// J
        /// </summary>
        public List<TableCommandColumn> Columns;
        /// <summary>
        /// TableCommandConditionList^
        /// </summary>
        public List<TableCommandCondition> Conditions;
        /// <summary>
        /// R}h
        /// </summary>
        public DbCommand Command;
        /// <summary>
        /// gf[^x[X
        /// </summary>
        protected DbAccessBase mDatabase;

#region constructors
        /// <summary>
        /// e[uR}h
        /// </summary>
        public TableCommand()
        {
            TableName = "";
            Columns = new List<TableCommandColumn>();
            Conditions = new List<TableCommandCondition>();

        }

        /// <summary>
        /// e[uR}h
        /// </summary>
        public TableCommand(string tableName)
        {
            this.TableName = tableName;
            Columns = new List<TableCommandColumn>();
            Conditions = new List<TableCommandCondition>();
        }


#endregion
        /// <summary>
        /// NG[gݗ
        /// </summary>
        /// <returns></returns>
        public abstract string BuildQuery();

        /// <summary>
        /// Jǉ
        /// </summary>
        /// <param name="col"></param>
        public void AppendColumn(TableCommandColumn col)
        {
            Columns.Add(col);
        }
        /// <summary>
        /// TableCommandConditionǉ
        /// </summary>
        /// <param name="cond"></param>
        public void AppendCondition(TableCommandCondition cond)
        {
            if (cond == null) return;
            Conditions.Add(cond);
        }
        /// <summary>
        /// TableCommandConditionǉ
        /// </summary>
        /// <param name="condOp"></param>
        /// <param name="cond"></param>
        public void AppendCondition(string condOp, TableCommandCondition cond)
        {
            if (cond == null) return;
            cond.ConditionOperator = condOp;
            Conditions.Add(cond);
        }
        /// <summary>
        /// R}h
        /// </summary>
        public void BuildCommand()
        {
            DbCommandBuilder builder = mDatabase.CreateDbCommandBuilder(BuildQuery(), CommandType.Text);

            Command = builder.GetCommand();
        }
        /// <summary>
        /// p[^
        /// </summary>
        public virtual void BuildParameters()
        {
            if (Command == null) BuildCommand();
            //XṼp[^ݒ
            int c = 0;
            for (int i = 0; i < Columns.Count; i++)
            {
                TableCommandColumn col = Columns[i];

                List<DbParameterBase> plist = col.Parameters;
                for (int j = 0; j < plist.Count; j++)
                {
                    DbParameterBase p = plist[j];
                    if (Command.Parameters.Contains(p.ParameterName))
                    {
                        Command.Parameters[p.ParameterName].Value = p.Value;
                    }
                    else
                    {

                        DbParameter param = Command.CreateParameter();
                        param.ParameterName = p.ParameterName;
                        param.DbType = p.Type;
                        param.Size = p.Size;
                        param.Value = p.Value;
                        Command.Parameters.Add(param);
                    }
                }
                c++;
            }
            //XṼp[^ݒ
            for (int i = 0; i < Conditions.Count; i++)
            {
                TableCommandCondition cond = Conditions[i];
                List<DbParameterBase> plist = cond.GetParameters();
                for (int j = 0; j < plist.Count; j++)
                {
                    DbParameterBase p = plist[j];

                    if (Command.Parameters.Contains(p.ParameterName))
                    {
                        Command.Parameters[p.ParameterName].Value = p.Value;

                    }
                    else
                    {
                        DbParameter param = Command.CreateParameter();
                        param.ParameterName = p.ParameterName;
                        param.DbType = p.Type;
                        param.Size = p.Size;
                        param.Value = p.Value;
                        Command.Parameters.Add(param);
                    }
                }

            }
            return;

        }
        /// <summary>
        /// J擾
        /// </summary>
        /// <param name="columnName"></param>
        /// <returns></returns>
        public TableCommandColumn GetColumn(string columnName)
        {
            for (int i = 0; i < Columns.Count; i++)
            {
                TableCommandColumn col = Columns[i];
                if (col.ColumnName == columnName) return col;

            }
            return null;           
        }
        /// <summary>
        /// Jݒ
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="newColumn"></param>
        /// <returns></returns>
        public TableCommandColumn SetColumn(string columnName,TableCommandColumn newColumn)
        {
            for (int i = 0; i < Columns.Count; i++)
            {
                TableCommandColumn col = Columns[i];
                if (col.ColumnName == columnName)
                {
                    Columns[i] = newColumn;
                    return col;
                }

            }
            return null;
        }
        /// <summary>
        /// Jݒ
        /// </summary>
        /// <returns></returns>
        public void SetColumnValue(FieldProperty p, object newValue)
        {
            for (int i = 0; i < Columns.Count; i++)
            {
                TableCommandColumn col = Columns[i];
                if (col.ColumnName == p.FieldName)
                {
                    if (col.Parameters.Count > 0)
                    {
                        col.Parameters[0].Value = DbAccessBase.FixValue(newValue);
                    }
                    return ;
                }

            }
            return ;
        }
        /// <summary>
        /// Jݒ
        /// </summary>
        /// <param name="aParamName"></param>
        /// <param name="aValue"></param>
        public void SetParam(string aParamName, object aValue)
        {
            DbParameter param;
            if (Command.Parameters.Contains(aParamName))
            {
                param = Command.Parameters[aParamName];
                param.Value = DbAccessBase.FixValue(aValue);
            }
            else
            {
                param = Command.CreateParameter();
                param.ParameterName = aParamName;
                param.Value = DbAccessBase.FixValue(aValue);
                Command.Parameters.Add(param);
                return;//m炷H
            }
        }


        /// <summary>
        /// s
        /// </summary>
        /// <returns></returns>
        public int Execute(DbAccessBase db)
        {
            this.mDatabase = db;
            if (Command == null)
            {
                BuildCommand();
            }
            BuildParameters();
            int r = db.executeUpdateCommand(Command);
            return r;
        }
        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="db"></param>
        /// <returns></returns>
        public DataSet ExecuteQuery(DbAccessBase db)
        {
            this.mDatabase = db;
            if (Command == null)
            {
                BuildCommand();

            }
            BuildParameters();
            DataSet r = db.executeCommand(Command);
            return r;

        }
        /// <summary>
        /// R}hsă[_[Ԃ
        /// </summary>
        /// <param name="db"></param>
        /// <returns></returns>
        public DbDataReader ExecuteReader(DbAccessBase db)
        {
            this.mDatabase = db;
            if (Command == null)
            {
                BuildCommand();

            }
            BuildParameters();
            DbDataReader r = db.ExecuteReader(Command);
            return r;

        }
        /// <summary>
        /// R}hsăXJ[Ԃ
        /// </summary>
        /// <param name="db"></param>
        /// <returns></returns>
        public object ExecuteScalar(DbAccessBase db)
        {
            this.mDatabase = db;
            if (Command == null)
            {
                BuildCommand();

            }
            BuildParameters();
            Command.Connection = db.GetConnection();
            object r = Command.ExecuteScalar();
            return r;

        }
    }
}
