using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;


namespace CFW.common.tableCommand
{
    /// <summary>
    /// e[uI
    /// </summary>
    public class TableSelectCommand : TableCommand
    {
        /// <summary>
        /// 
        /// </summary>
        public List<TableCommandColumn> OrderColumns;

        /// <summary>
        /// f[^SELECTR}h
        /// </summary>
        public TableSelectCommand() : base()
        {
            OrderColumns = new List<TableCommandColumn>();
        }
        /// <summary>
        /// f[^SELECTR}h
        /// </summary>
        /// <param name="tname"></param>
        public TableSelectCommand(string tname) : base(tname)
        {
            OrderColumns = new List<TableCommandColumn>();

        }
        /// <summary>
        /// J̕яǉ
        /// </summary>
        /// <param name="col"></param>
        public void AppendOrderColumn(TableCommandColumn col)
        {
            OrderColumns.Add(col);
        }
        /// <summary>
        /// p[^
        /// </summary>
        public override void BuildParameters()
        {
            if (Command == null) BuildCommand();
            //IɃp[^nƂ͕s\
            //̃p[^ݒ
            for (int i = 0; i < Conditions.Count; i++)
            {
                TableCommandCondition cond = Conditions[i];
                List<DbParameterBase> plist = cond.GetParameters();
                for (int j = 0; j < plist.Count; j++)
                {
                    DbParameterBase p = plist[j];

                    if (Command.Parameters.Contains(p.ParameterName))
                    {
                        Command.Parameters[p.ParameterName].Value = p.Value;

                    }
                    else
                    {
                        DbParameter param = Command.CreateParameter();
                        param.ParameterName = p.ParameterName;
                        param.DbType = p.Type;
                        param.Size = p.Size;
                        param.Value = p.Value;
                        Command.Parameters.Add(param);

                    }
                }

            }
            return;
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override string BuildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("SELECT " + Environment.NewLine);
            for (int i = 0; i < Columns.Count; i++)
            {
                TableCommandColumn col = Columns[i];
                if (i > 0) b.Append(",");
                b.Append(" " + col.ColumnName + Environment.NewLine);

            }
            b.Append(" FROM " + TableName);
            if (Conditions.Count > 0)
            {
                b.Append(" WHERE ");
                for (int i = 0; i < Conditions.Count; i++)
                {
                    TableCommandCondition cond = Conditions[i];
                    b.Append(" "  + cond.BuildCondition() + Environment.NewLine);

                }

            }
            if (OrderColumns.Count > 0)
            {
                b.Append(" ORDER BY ");
                for (int i = 0; i < Conditions.Count; i++)
                {
                    if (i > 0) b.Append(",");
                    TableCommandColumn col = OrderColumns[i];
                    b.Append(" " + col.ColumnName + Environment.NewLine);

                }
            }
            return b.ToString();
        }
        
    }
}
