using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Diagnostics.CodeAnalysis;
using System.Drawing;
using System.Drawing.Design;
using System.Globalization;
using System.Security.Permissions;
using System.Web;
using System.Web.UI;
using System.Web.Util;

namespace OFW.WebControls
{
    /// <summary>
    /// X^CV[gQƃ}l[Wւ̃vLV
    /// </summary>
    [
    AspNetHostingPermission(SecurityAction.LinkDemand, Level = AspNetHostingPermissionLevel.Minimal),
    AspNetHostingPermission(SecurityAction.InheritanceDemand, Level = AspNetHostingPermissionLevel.Minimal),
    DefaultProperty("Scripts"),
    NonVisualControl(),
    ParseChildren(true),
    PersistChildren(false)
    ]
    public class StyleSheetManagerProxy : Control
    {
        private StyleSheetReferenceCollection _styleSheets;
        private StyleSheetManager _manager;
        /// <summary>
        /// \z
        /// </summary>
        [
        Category("Behavior"),
        DefaultValue(null),
        PersistenceMode(PersistenceMode.InnerProperty),
        MergableProperty(false),
        ]
        public StyleSheetReferenceCollection StyleSheets
        {
            get
            {
                if (_styleSheets == null)
                {
                    _styleSheets = new StyleSheetReferenceCollection();
                }
                return _styleSheets;
            }
        }
        private StyleSheetManager Manager
        {
            get
            {
                if (_manager == null)
                {
                    Page page = Page;
                    if (page == null)
                    {
                        throw new Exception("!no page");
                    }
                    _manager = StyleSheetManager.GetCurrent(Page);
                    if (_manager == null)
                    {
                        throw new Exception("!no manager");
                    }
                }
                return _manager;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="e"></param>
        [SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers")]
        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);

            if (!DesignMode)
            {
                Manager.RegisterProxy(this);
            }
        }

    }
}
