using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using OFW.Models;

namespace OFW.Windows.Controls
{
    /// <summary>
    /// Pȃ`FbN{bNX̃Xg
    /// </summary>
    public partial class CheckBoxList : UserControl
    {
        Enumerations _baseList;
        private int _itemHeight;

        /// <summary>
        /// `FbN{bNXvf̍w肷B
        /// </summary>
        public int ItemHeight
        {
            get { return _itemHeight; }
            set { _itemHeight = value; }
        }
        private int _itemWidth;
        /// <summary>
        /// `FbN{bNXvf̕w肷B
        /// </summary>
        public int ItemWidth
        {
            get { return _itemWidth; }
            set { _itemWidth = value; }
        }

        private FlowDirection _flowDirection;
        /// <summary>
        /// vfׂݒ肷B
        /// </summary>
        public FlowDirection FlowDirection
        {
            get { return _flowDirection; }
            set { _flowDirection = value; }
        }

        /// <summary>
        /// \z
        /// </summary>
        public CheckBoxList()
        {
            InitializeComponent();
            
        }
        /// <summary>
        /// `FbN{bNXvf̃f[^\[XݒE擾
        /// </summary>
        public object DataSource
        {
            get
            {
                return _baseList;
            }
            set
            {
                _baseList = value as Enumerations;
            }
        }

        private void CheckBoxList_Load(object sender, EventArgs e)
        {
            container.FlowDirection = _flowDirection;
        }
        /// <summary>
        /// \XVB
        /// </summary>
        public override void Refresh()
        {
            InitializeControls();
        }
        /// <summary>
        /// w肵lʎqƂ`FbN{bNXvfIԂɂBw肳ĂȂvf͔IԂɂ
        /// </summary>
        /// <param name="values"></param>
        public void setValues(IEnumerable values)
        {
            foreach (Control c in container.Controls)
            {
                CheckBox child = c as CheckBox;
                IEnumerationItem item = child.Tag as IEnumerationItem;

                child.Checked = false;
                if (values != null)
                {
                    foreach (object value in values)
                    {
                        if (item.idEqualsTo(value))
                        {
                            child.Checked = true;
                            break;
                        }
                        else
                        {
                        }
                    }
                }
                
            }


        }
        /// <summary>
        /// Iꂽl(񋓍ڂ̎ʎq)𓾂B
        /// </summary>
        /// <returns></returns>
        public IEnumerable getValues()
        {
            List<object> values = new List<object>();
            foreach (Control c in container.Controls)
            {
                CheckBox child = c as CheckBox;
                if (child.Checked)
                {
                    IEnumerationItem item = child.Tag as IEnumerationItem;

                    values.Add(item.Id);
                }
            }
            return values.ToArray();
        }

        private void InitializeControls()
        {
            container.Controls.Clear();
            if (_baseList == null) return;
            foreach (object e in _baseList)
            {
                IEnumerationItem item = e as IEnumerationItem;
                if (item == null) continue;

                CheckBox c = new CheckBox();
                c.Text = item.Name;
                c.Checked = item.IsDefault;
                c.Tag = item;
                if (_itemHeight > 0)
                {
                    c.Height = _itemHeight;
                }
                if (_itemWidth> 0)
                {
                    c.Width = _itemWidth;
                }

                container.Controls.Add(c);
            }
        }
    }
}
