using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.ComponentModel;

using OFW.FieldProperties;
using OFW.Forms;
using OFW.Forms.Filters;
using OFW.Validators;

namespace OFW.Windows.Forms.Adapters
{
    /// <summary>
    /// t͗pA_v^[vf
    /// </summary>
    public class DateInputElement : OFW.Forms.FormAdapterElement
    {
        enum ControlChars : int
        {
            CTRL_A = 0x01,
            CTRL_C = 0x03,
            CTRL_X = 0x18,
            CTRL_V = 0x16,
            CTRL_Z = 0x1a,
            BACKSPACE = 0x08
        };

        TextBox theControl;
        string inputFormat;
        string outputFormat;
        /// <summary>
        /// //A}CiXA_A؂AobNXy[XActrl-c,ctrl-v,ctrl-a,ctrl-z
        /// </summary>
        private Regex acceptableCharPattern = new Regex(@"[\d\-/:\. ]");

        /// <summary>
        /// ftHg
        /// </summary>
        public DateInputElement()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="control">eLXg{bNX</param>
        public DateInputElement(TextBox control)
        {
            this.theControl = control;
            setup("yyyy/M/d","");

            this.validator = createDefaultValidator();
            attachHandlers();
        }
        /// <summary>
        /// \z
        /// <para>͉\ȑŜ̕Ɛxw肷Bw肷`SQL decimalƓ`(Ŝ̕A_ȉ) </para>
        /// <para>\ptH[}bgw肷邱ƂŃJ}؂ȂǂB</para>
        /// </summary>
        /// <param name="control">eLXg{bNX</param>
        /// <param name="inputFormat">͗ptH[}bg</param>
        /// <param name="outputFormat">\ptH[}bg</param>
        public DateInputElement(TextBox control,string inputFormat,string outputFormat)
        {
            this.theControl = control;
            setup(inputFormat,outputFormat);
            attachHandlers();
        }
        /// <summary>
        /// ̗vpeBw肵č\z
        /// <para>\ptH[}bgɂ̓vpeB̕\ptH[}bg(DisplayFormat)gB</para>
        /// </summary>
        /// <param name="control">̓Rg[</param>
        /// <param name="property">̗vpeB</param>
        public DateInputElement(TextBox control, FieldProperty property)
        {
            this.theControl = control;
            setup(property,property.DisplayFormat);

            attachHandlers();
        }
        /// <summary>
        /// ̗vpeBw肵č\z
        /// <para>\ptH[}bgw肷邱ƂŃJ}؂ȂǂB</para>
        /// </summary>
        /// <param name="control">̓Rg[</param>
        /// <param name="property">̗vpeB</param>
        /// <param name="inputFormat">͗ptH[}bg</param>
        /// <param name="outputFormat">\ptH[}bg</param>
        public DateInputElement(TextBox control, FieldProperty property,string inputFormat, string outputFormat)
        {
            this.theControl = control;
            setup(property,outputFormat);

            attachHandlers();
        }
        /// <summary>
        /// tH[}bgw肵č\z
        /// </summary>
        /// <param name="inputFormat">͗ptH[}bg</param>
        /// <param name="outputFormat">\ptH[}bg</param>
        public void setup(string inputFormat, string outputFormat)
        {
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;

            this.filter = new DateTimeFilter(inputFormat);
            this.validator = createDefaultValidator();
        }
        /// <summary>
        /// ̗vpeBݒ肵ē͏Ȃǂ\zB
        /// </summary>
        /// <param name="property"></param>
        /// <param name="outputFormat">\ptH[}bg</param>
        public void setup(FieldProperty property, string outputFormat)
        {
            this.inputFormat = property.Format;
            this.outputFormat = outputFormat;

            this.filter = new DateTimeFilter(property.Format);
            this.validator = FieldValidator.GetInstance(property);
        }
        
        /// <summary>
        /// {IȌ؃IuWFNg쐬
        /// </summary>
        /// <returns></returns>
        private FieldValidator createDefaultValidator()
        {
            FieldProperty property = FieldProperty.NewInstance("datetime", "", theControl.Name, "", 8, 26, 0, true, 0, false);
            property.DisplayFormat = this.outputFormat;
            property.Format = this.inputFormat;
            FieldValidator validator = FieldValidator.GetInstance(property);
            return validator;
        }

        /// <summary>
        /// Rg[̒l荞
        /// </summary>
        public override void UpdateField()
        {
            this.theValue = this.filter.FilterValue(this.theControl.Text);

        }
        /// <summary>
        /// \
        /// </summary>
        public override void Render()
        {
            if (this.isValid)
            {
                
                 this.theControl.Text = formatValue(theValue);
            }
            else
            {
                this.theControl.Text = OFW.Util.StringUtil.StringValue(this.theValue);
            }
        }
        /// <summary>
        /// w̒l݂̃[ɊÂtH[}bgB
        /// </summary>
        /// <param name="value">tH[}bgl</param>
        /// <returns></returns>
        private string formatValue(object value)
        {
            string formatted = "";
            if (this.outputFormat == "") formatted = OFW.Util.StringUtil.StringValue(value);
            else
            {
                string sfFormatString = "{0:" + this.outputFormat + "}";
                formatted = string.Format(sfFormatString, value);
            }
            return formatted;
        }
        /// <summary>
        /// tH[JXAEgɃtB^[Kp邩
        /// </summary>
        public override bool FilterOnBlur
        {
            get
            {
                return base.FilterOnBlur;
            }
            set
            {
                base.FilterOnBlur = value;
                if(filterOnBlur) this.theControl.Leave += blurHandler;
            }
        }
        /// <summary>
        /// tH[JXAEg̃tB^[Kp
        /// </summary>
        /// <param name="sender">CxgM</param>
        /// <param name="e">Cxg</param>
        protected void blurHandler(object sender, EventArgs e)
        {
            this.theControl.Text = formatValue( this.filter.FilterValue(this.theControl.Text) );
        }
        /// <summary>
        /// Cxgnh[̓Rg[ɕRt
        /// </summary>
        private void attachHandlers()
        {
            this.theControl.KeyPress += keyPressHandler;
            this.theControl.Validating += validatingHandler;
        }
        /// <summary>
        /// L[(́ARg[ɑ΂鐧䕶͂Ȃ)
        /// </summary>
        /// <param name="sender">CxgM</param>
        /// <param name="e">Cxg</param>
        private void keyPressHandler(object sender, System.Windows.Forms.KeyPressEventArgs e)
        {
            if (isControlChar(e.KeyChar)) return;

            string newCharString = (new string(e.KeyChar, 1));
            if (!isAcceptable(newCharString))
            {
                e.Handled = true;
                return;
            }
        }
        /// <summary>
        /// ͕䕶𔻒肷
        /// </summary>
        /// <param name="code">͕R[h</param>
        /// <returns>͕䕶̏ꍇtrue</returns>
        private bool isControlChar(char code)
        {
            int needle = (int)code;
            if (needle == (int)ControlChars.BACKSPACE) return true;
            if (needle == (int)ControlChars.CTRL_A) return true;
            if (needle == (int)ControlChars.CTRL_C) return true;
            if (needle == (int)ControlChars.CTRL_V) return true;
            if (needle == (int)ControlChars.CTRL_X) return true;
            if (needle == (int)ControlChars.CTRL_Z) return true;

            return false;
        }
        /// <summary>
        /// ͕͉\肷
        /// </summary>
        /// <param name="newCharString">͕</param>
        /// <returns>͉\Ȃtrue</returns>
        private bool isAcceptable(string newCharString)
        {
            return acceptableCharPattern.IsMatch(newCharString);
          
        }
        /// <summary>
        /// Windows.FormsvalidatingCxg̃nh
        /// <para>CxgIuWFNgCancel^ɂƃtH[JXړ𐧌ł邪AtH[鎖oȂȂ̂łł͓͒lătH[}bg邾</para>
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void validatingHandler(object sender, CancelEventArgs e)
        {
            object newValue = filter.FilterValue(theControl.Text);
            if (newValue == null)
            {
                theControl.Text = "";
                return;
            }
            if (newValue is DateTime?)
            {
                DateTime? d = (DateTime?)newValue;
                if (d != null) theControl.Text = formatValue(d);
                return;
            }
            theControl.Text = newValue.ToString();
        }
    }
}
