using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Acl
{
    /// <summary>
    /// ANZX@\
    /// </summary>
    /// <example>
    /// ̃NX@\邽߂app.configaclݒ肪KvB
    /// <code>  &lt;acl
    /// providerClass="OFW.Acl.DbAcl,OFW.Acl" -- NX̌^B`ĂAZûKv
    /// connection="acl" -- f[^ڑgꍇ̐ڑ於
    /// />
    /// </code></example>
    public class AclFactory
    {
        static Config.ConfigFile appConfig;
        static AclConfigSection aclConfig;
        /// <summary>
        /// CX^XA擾
        /// </summary>
        /// <returns>AccessControlIuWFNg</returns>
        public static AccessControl GetInstance()
        {
            LoadConfig();

            string providerClass = aclConfig.ProviderClass;
            System.Diagnostics.Debug.Assert((providerClass != ""), "acl provider not set");

            AccessControl p = (AccessControl)Util.ClassLoader.CreateInstance(providerClass, "");
            System.Diagnostics.Debug.Assert((p != null), "acl Provider not set");


            p.Init(aclConfig);
            return p;
        }
        static void LoadConfig()
        {
            if (appConfig == null) appConfig = OFW.Config.ConfigFactory.GetConfig();
            if(aclConfig == null) aclConfig = (AclConfigSection)appConfig.GetSection("acl");
        }

    }
}
