using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;

namespace OFW.FieldProperties
{
    /// <summary>
    /// BytepFieldProperty̎
    /// </summary>
    /// <remarks>őlAŏlǉ</remarks>
    [Serializable()]
    public class ByteFieldProperty : FieldProperty
    {
        /// <summary>
        /// ől
        /// </summary>
        public byte MaxValue = Byte.MaxValue;
        /// <summary>
        /// ŏl
        /// </summary>
        public byte MinValue = Byte.MinValue;

        /// <summary>
        /// defualt constructor
        /// </summary>
        public ByteFieldProperty()
            : base()
        {
            FieldType = typeof(byte);
            setup("tinyint", "", "", "", 1, 3, 0, false, 0, false);

        }
        /// <summary>
        /// default construct
        /// </summary>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        public ByteFieldProperty(string entityName, string fieldName, string displayName)
            : base()
        {

            FieldType = typeof(byte);
            setup("tinyint", entityName, fieldName, displayName, 1, 3, 0, false, 0, false);
        }

        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂFieldProperty</param>
        /// <remarks>FieldProperty̏gp邪AʂłByteƂĈꍇȂǂɎgp</remarks>
        public ByteFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(byte);
            if (p.GetType() == this.GetType())
            {
                MaxValue = ((ByteFieldProperty)p).MaxValue;
                MinValue = ((ByteFieldProperty)p).MinValue;
            }
        }

        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>ő咷</returns>
        public override int MaxLength
        {
            get
            {
                int max = this.Precision;

                //","؂̕ //3Ȃ̂ł肦Ȃ
                //̕ //Byte͕ȂB
                //_̕ //珬_ȂB

                return max;
            }
        }
        /// <summary>
        /// ftHgl̕\
        /// </summary>
        /// <returns></returns>
        public override string DefaultValueDisplay()
        {
            return NumberUtil.Format(this.DefaultValue, "#");
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                this.mDefaultValue = NumberUtil.Value<byte?>(value);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new ByteFieldProperty(this);
        }

    }
}
