using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;

namespace OFW.FieldProperties
{
    /// <summary>
    /// DateTimepFieldProperty
    /// </summary>
    [Serializable()]
    public class DateFieldProperty : FieldProperty
    {
        /// <summary>
        /// Γt͋
        /// </summary>
        /// <remarks>-7(1TԑO)Ȃǂ̓͂B</remarks>
        public bool AllowRelative = false;

        /// <summary>
        /// eŏt
        /// </summary>
        public DateTime MinValue = DateTime.MinValue;
        /// <summary>
        /// eőt
        /// </summary>
        public DateTime MaxValue = DateTime.MaxValue;

        /// <summary>
        /// default constructor
        /// </summary>
        /// <remarks>ł͑ΓtȂ</remarks>
        public DateFieldProperty()
            : base()
        {
            FieldType = typeof(DateTime);
            setup("datetime", "", "", "", 16, 23, 3, false, 0, false);

            Format = "yyyy/MM/dd HH:mm:ss";
            AllowRelative = false;
        }
        /// <summary>
        /// default construct
        /// </summary>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        public DateFieldProperty(string entityName, string fieldName, string displayName)
            : base()
        {
            FieldType = typeof(int);
            setup("datetime", entityName, fieldName, displayName, 16, 23, 3, false, 0, false);
            Format = "yyyy/MM/dd HH:mm:ss";
            AllowRelative = false;
        }

        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂvpeB</param>
        public DateFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(DateTime);
            if (p.GetType() == this.GetType())
            {
                Format = ((DateFieldProperty)p).Format;
                AllowRelative = ((DateFieldProperty)p).AllowRelative;
            }
            else
            {
                Format = "yyyy/MM/dd HH:mm:ss";
                AllowRelative = false;
            }
        }
        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>͉\ȍő咷</returns>
        public override int MaxLength
        {
            get
            {
                //ttH[}bg̒ȏɓ͂邱Ƃ͂Ȃ

                return this.Format.Length;
            }
        }
        /// <summary>
        /// ftHgl̕\
        /// </summary>
        /// <returns></returns>
        public override string DefaultValueDisplay()
        {
            return DateUtil.Format(this.DefaultValue, this.Format);
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                if (value == null)
                {
                    this.mDefaultValue = null;
                }
                else
                {
                    string valueString = value.ToString();
                    if (valueString == "")
                    {
                        this.mDefaultValue = null;
                    }
                    else
                    {
                        this.mDefaultValue = DateUtil.DateValue(value);
                    }
                }
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new DateFieldProperty(this);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="length"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        public override void setSize(int length, int precision, int scale)
        {
            //ȂBeł̂͌^
        }
    }
}
