using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.IO;
using OFW.Util;
using Newtonsoft.Json;

namespace OFW.Forms
{
    /// <summary>
    /// e평p[^BɉʊԂŎ󂯓nʍ\zp̃p[^ƂĎgpB
    /// </summary>
    public class InitialParameters
    {
        /// <summary>
        /// Otp[^
        /// </summary>
        List<KeyValuePair<string, object>> parameters;
        /// <summary>
        /// ftHg\z
        /// </summary>
        public InitialParameters()
        {
            clear();
        }
        /// <summary>
        /// p[^
        /// </summary>
        public void clear()
        {
            parameters = new List<KeyValuePair<string, object>>();
        }
        int indexOf(string name)
        {
            int index = this.parameters.FindIndex(
                 delegate(KeyValuePair<string, object> kv)
                 {
                     return (kv.Key == name);
                 }
            );
            return index;
        }
        int indexOf(string name, int start)
        {
            int index = this.parameters.FindIndex(start,
                 delegate(KeyValuePair<string, object> kv)
                 {
                     return (kv.Key == name);
                 }

            );
            return index;
        }
        /// <summary>
        /// w̑݃`FbN
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public bool nameExists(string name)
        {
            return (indexOf(name) >= 0);
        }
        /// <summary>
        /// w̒l擾
        /// </summary>
        /// <param name="name">w</param>
        /// <returns>wɊYl</returns>
        public object get(string name)
        {
            int index = indexOf(name);
            if (index < 0) return null;
            return this.parameters[index].Value;
        }
        /// <summary>
        /// Oƒl̃yAݒBOłɍ݂ΒuςAΒǉB
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public void set(string name, object value)
        {
            KeyValuePair<string, object> item = new KeyValuePair<string, object>(name, value); ;
            int index = indexOf(name);
            if (index < 0)
            {
                parameters.Add(item);
            }
            else
            {
                parameters[indexOf(name)] = item;
            }
        }
        /// <summary>
        /// indexer
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public object this[string name]
        {
            get { return get(name); }
            set { set(name, value); }
        }
        /// <summary>
        /// JSON񂩂\z
        /// </summary>
        /// <param name="jsonString"></param>
        /// <returns></returns>
        /// <remarks>z͑ΉĂȂBGȍ\͑ΉĂȂBôQueryStringx̃p[^̂</remarks>
        public void fromJSONString(string jsonString)
        {
            parameters = new List<KeyValuePair<string, object>>();
            if (String.IsNullOrEmpty(jsonString))
            {
                //IuWFNgÂړIł͂Ȃ̂ł܂ƂJSON񂶂ȂΓp[^邾łB
                return;
            }
            if (!jsonString.StartsWith("{"))
            {
                //܂ƂJSON񂶂ȂB
                return;
            }
            Newtonsoft.Json.JsonSerializer serializer = new JsonSerializer();
            JavaScriptObject jsObject = serializer.Deserialize(new JsonReader(new StringReader(jsonString))) as JavaScriptObject;

            
            IEnumerator e = jsObject.Keys.GetEnumerator();
            while (e.MoveNext())
            {
                string key = e.Current.ToString();
                parameters.Add(new KeyValuePair<string, object>(key, jsObject[key]));
            }
        }
        /// <summary>
        /// NG[񂩂p[^\zB
        /// </summary>
        /// <param name="queryString"></param>
        /// <remarks>fR[hK{parser̂ԂȂ̂Ō񂵁B</remarks>
        public virtual void fromQueryString(string queryString)
        {
            throw new Exception("method not implemented");
        }
        /// <summary>
        /// JSONɕϊ
        /// </summary>
        /// <param name="o"></param>
        /// <returns></returns>
        public string toJSONString(object o)
        {
            JavaScriptObject jsObject = new JavaScriptObject();
            Newtonsoft.Json.JsonSerializer serializer = new JsonSerializer();
            StringWriter writer = new StringWriter();
            foreach (KeyValuePair<string, object> item in parameters)
            {
                jsObject.Add(item.Key, item.Value);
            }
            serializer.Serialize(writer,jsObject);
            return writer.ToString();
        }
        /// <summary>
        /// QueryStringɕϊ
        /// </summary>
        /// <param name="o"></param>
        /// <returns></returns>
        /// <remarks>GR[hK{ł͉Ȃ̂ŁuƂ肠vGR[hȂŎ</remarks>
        public virtual string toQuueryString(object o)
        {
            StringBuilder builder = new StringBuilder();
            foreach (KeyValuePair<string, object> item in parameters)
            {
                if (builder.Length > 0) builder.Append("&");
                builder.Append(item.Key + "=" + StringUtil.StringValue(item.Value));
            }

            return builder.ToString();
        }



    }
}
