using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using OFW.Util;

namespace OFW.IO
{
    /// <summary>
    /// CSVǎ摕u
    /// </summary>
    public class CsvReader
    {
        TextReader reader;

        Dictionary<string, int> columnDefinition;
        /// <summary>
        /// `
        /// </summary>
        public Dictionary<string, int> ColumnDefinition
        {
            get { return columnDefinition; }
        }
        bool firstLineAsColumnDefinition;
        /// <summary>
        /// ŏ̍s`ƌ邩
        /// </summary>
        public bool FirstLineAsColumnDefinition
        {
            get { return firstLineAsColumnDefinition; }
            set { firstLineAsColumnDefinition = value; }
        }
        string firstLine;
        List<string> values;
        string lineBuffer;
        int columnDelimiter = ',';
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="reader">ǎ摕u</param>
        public CsvReader(TextReader reader)
        {
            this.reader = reader;
            firstLineAsColumnDefinition = true;
            firstLine = "";
            lineBuffer = "";
            columnDefinition = new Dictionary<string, int>();
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="s">̕</param>
        public CsvReader(string s)
        {
            this.reader = new StringReader(s);
            firstLineAsColumnDefinition = true;
            firstLine = "";
            lineBuffer = "";
            columnDefinition = new Dictionary<string, int>();
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="columnDelimiter">񕪗L</param>
        public CsvReader(string s,int columnDelimiter)
        {
            this.reader = new StringReader(s);
            firstLineAsColumnDefinition = true;
            firstLine = "";
            lineBuffer = "";
            this.columnDelimiter = columnDelimiter;
            columnDefinition = new Dictionary<string, int>();
        }
        /// <summary>
        /// ̍s
        /// </summary>
        /// <returns></returns>
        public bool Next()
        {
            //ȏ͂Ȃ
            if (lineBuffer == null) return false;


            if (firstLineAsColumnDefinition)
            {
                if (firstLine == "")
                {
                    firstLine = reader.ReadLine();
                    ParseHeader();
                }
            }
            lineBuffer = reader.ReadLine();
            if (lineBuffer == null)
            {
                return false;
            }
            else
            {
                ParseLine();
                return true;
            }

        }
        /// <summary>
        /// wb_[WJ
        /// </summary>
        void ParseHeader()
        {
            CsvTokenizer tokenizer = new CsvTokenizer(this.firstLine, this.columnDelimiter);
            int i = 0;
            while (tokenizer.HasMoreTokens())
            {
                columnDefinition.Add(tokenizer.NextToken(), i++);
            }
        }
        /// <summary>
        /// sWJ
        /// </summary>
        void ParseLine()
        {
            values = new List<string>();
            CsvTokenizer tokenizer = new CsvTokenizer(this.lineBuffer, this.columnDelimiter);
            while (tokenizer.HasMoreTokens())
            {
                values.Add(Unescape(tokenizer.NextToken()));
            }
        }
        /// <summary>
        /// ݂̍sl擾
        /// </summary>
        /// <param name="index">ԍ</param>
        /// <returns>ԍɑΉ̒l</returns>
        public string GetValue(int index)
        {
            if (index < 0) return null;
            if (index >= this.values.Count) return null;
            return this.values[index];
        }
        /// <summary>
        /// ݂̍sl擾
        /// </summary>
        /// <param name="name"></param>
        /// <returns>񖼂ɑΉ̒l</returns>
        public string GetValue(string name)
        {
            int index = -1;
            if (this.columnDefinition.ContainsKey(name))
            {
                index = this.columnDefinition[name];
            }
            if (index < 0) return null;
            if (index >= this.values.Count) return null;
            return this.values[index];
        }
        /// <summary>
        /// GXP[vꂽɖ߂
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        string Unescape(string s)
        {
            StringBuilder b = new StringBuilder(s);
            b.Replace("\\t", "\t");
            b.Replace("\\v", "\v");
            b.Replace("\\r", "\r");
            b.Replace("\\n", "\n");
            b.Replace("\\b", "\b");
            b.Replace("\\\\", "\\");

            return b.ToString();
        }
        /// <summary>
        /// gpĂXg[
        /// </summary>
        public void Close()
        {
            this.reader.Close();
        }
    }
}
