using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.Data;

namespace OFW.Models
{
    /// <summary>
    /// GeBeB
    /// </summary>
    public abstract class Entity : IEntity, OFW.Models.ITypedSerializable
    {
        bool isNew;
        bool isModified;
        bool isDeleted;

        /// <summary>
        /// ftHg\z
        /// </summary>
        public Entity()
        {
            isNew = true;
            isModified = false;
            isDeleted = false;
        }
        /// <summary>
        /// nametB[hɒlZbg
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public abstract void SetValue(string name, object value);
        /// <summary>
        /// nametB[h̒l
        /// </summary>
        /// <param name="name"></param>
        public abstract object GetValue(string name);

        /// <summary>
        /// VACYp^Cv
        /// </summary>
        [XmlAttribute(AttributeName="__type")]
        public virtual string TypeName
        {
            get
            {
                Type t = this.GetType();
                return t.FullName + "," + t.AssemblyQualifiedName;
            }
            set
            {
                //do nothing
            }
        }
        /// <summary>
        /// DataRowsf[^
        /// </summary>
        /// <param name="row">ɂȂsf[^</param>
        public virtual void Map(DataRow row)
        {
            this.Map(row, "");
        }

        /// <summary>
        /// DataRowsf[^
        /// </summary>
        /// <param name="row">ɂȂsf[^</param>
        /// <param name="alias">e[uʖ</param>
        public virtual void Map(DataRow row, string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            for (int c = 0; c < cols.Count; c++)
            {
                this.SetValue(GetFieldName(cols[c].ColumnName, alias), row[c]);

            }
        }
        /// <summary>
        /// DataReadersf[^
        /// </summary>
        /// <param name="reader">ɂȂreaderIuWFNg</param>
        public virtual void Map(IDataReader reader)
        {
            for (int c = 0; c < reader.FieldCount; c++)
            {
                this.SetValue(GetFieldName(reader.GetName(c), ""), reader.GetValue(c));
            }
        }
        /// <summary>
        /// DataReadersf[^
        /// </summary>
        /// <param name="reader">ɂȂreaderIuWFNg</param>
        /// <param name="alias">e[uʖ</param>
        /// <remarks>gĂǂxBɗ񐔂ꍇA񌟍ɂRXgMap(DataRow)gꍇ傫B</remarks>
        [Obsolete]
        public virtual void Map(IDataReader reader, string alias)
        {
            for (int c = 0; c < reader.FieldCount; c++)
            {
                this.SetValue(GetFieldName(reader.GetName(c), alias), reader.GetValue(c));
            }
        }
        /// <summary>
        /// w񖼂ƃe[uʖɊÂtB[h擾
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="alias">e[uʖ</param>
        /// <returns>w񖼂ƃe[uʖɊÂtB[h</returns>
        protected string GetFieldName(string columnName, string alias)
        {
            if (alias == "")
            {
                int aliasLastPos = columnName.IndexOf("__");
                if (aliasLastPos > 0)
                {
                    return columnName.Substring(aliasLastPos + 2);
                }
                return columnName;
            }
            else
            {
                return columnName.Replace(alias + "__", "");
            }
        }
        /// <summary>
        /// e[uʖƗ񖼂IĂ̗͂̕ʖgݗ
        /// </summary>
        /// <param name="alias">e[uʖ</param>
        /// <param name="columnName">̗</param>
        /// <returns>̕ʖ</returns>
        protected string BuildColumnName(string alias, string columnName)
        {
            if (alias == "") return columnName;

            //Bstring.Format vs Z
            //return string.Format("{0}__{1}", alias, columnName);
            return alias + "__" + columnName;
        }
        /// <summary>
        /// 񑶍݃`FbN
        /// </summary>
        /// <param name="row">sf[^</param>
        /// <param name="colName"></param>
        /// <returns>sɗ񂪑݂鎞true</returns>
        protected bool ColumnExists(DataRow row, string colName)
        {
            return row.Table.Columns.Contains(colName);
        }
        /// <summary>
        /// ̍sVKs
        /// </summary>
        /// <remarks>DataSource#save()gpꍇAIsNew == true  IsModified == truȅꍇǉɂȂB</remarks>
        public bool IsNew
        {
            get { return this.isNew; }
            set { this.isNew = value; }
        }
        /// <summary>
        /// ̍sύXĂ邩
        /// </summary>
        /// <remarks>DataSource#save()gpꍇAIsNew == false  IsModified == truȅꍇǉɂȂB</remarks>
        public bool IsModified
        {
            get { return this.isModified; }
            set { this.isModified = value; }

        }
        /// <summary>
        /// ̍s폜Ă邩
        /// </summary>
        /// <remarks>DataSource#save()gpꍇAIsDeleted == true̎YGeBeB͉iɍ폜</remarks>
        public bool IsDeleted
        {
            get { return this.isDeleted; }
            set { this.isDeleted = value; }
        }


        #region ITypedSerializable o
        /// <summary>
        /// ^(VACYp) 
        /// </summary>
        [System.Xml.Serialization.XmlAttribute]
        public virtual string __TypeName
        {
            get
            {
                Type t = this.GetType();
                string s = t.FullName + "," + t.Assembly.GetName().Name;
                return s;
            }
            set
            {
                //do nothing
            }
        }

        #endregion


        /// <summary>
        /// ̃IuWFNg̃L[Ǝw肵L[
        /// </summary>
        /// <returns></returns>
        public virtual bool keyEquals(Entity target)
        {
            return false;
        }

        /// <summary>
        /// ̃IuWFNguvǂ
        /// </summary>
        /// <returns></returns>
        public virtual bool isEmpty()
        {
            return false;
        }


    }
}
