using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;
namespace OFW.Models
{
    /// <summary>
    /// e[uvpeB
    /// </summary>
    public abstract class EntityProperty : IEntityProperty,ICloneable
    {
        string entityName = "";
        string catalog = "";
        string schema = "";
        string alias = "";

        string modifiedByField = "modified_by";
        string modifiedAtField = "modified_at";

        string createdByField = "created_by";
        string createdAtField = "created_at";

        /// <summary>
        /// ̃vpeB琶GeBeB̃^Cv
        /// </summary>
        public Type entityType;
        #region IEnumerator
        /// <summary>
        /// tB[hvpeB񋓎q擾
        /// </summary>
        /// <returns>vpeB񋓎q</returns>
        public virtual IEnumerable<OFW.FieldProperties.FieldProperty> Fields()
        {
            //TODO: t2m̃[U[GetFields > Fields̈ڍsÎ҂Ĉȉ̂悤ɕύX
            // return null; //TuNXŎׂłł͉Ȃ̂B
            using(IEnumerator<OFW.FieldProperties.FieldProperty> e = GetFields())
            {
                while (e.MoveNext())
                {
                    yield return e.Current;
                }
            }
        }
        /// <summary>
        /// XVΏۃtB[hvpeB񋓎q擾
        /// </summary>
        /// <remarks>UpdateFields()Ɉڍs\</remarks>
        /// <returns>vpeB񋓎q</returns>
        public virtual IEnumerable<OFW.FieldProperties.FieldProperty> UpdateFields()
        {
            foreach(OFW.FieldProperties.FieldProperty p in Fields())
            {
                if (p.DoUpdate) yield return p;

            }
        }
        /// <summary>
        /// L[vpeB񋓎q擾
        /// </summary>
        /// <remarks>PrimaryKeys()Ɉڍs\</remarks>
        /// <returns>vpeB񋓎q</returns>
        public virtual IEnumerable<OFW.FieldProperties.FieldProperty> PrimaryKeys()
        {
            //TODO: t2m̃[U[GetFields > Fields̈ڍsÎ҂Ĉȉ̂悤ɕύX
            // return null; //TuNXŎׂłł͉Ȃ̂B
            using (IEnumerator<OFW.FieldProperties.FieldProperty> e = GetPrimaryKeys())
            {
                while (e.MoveNext())
                {
                    yield return e.Current;
                }
            }
        }
        #endregion
        #region IEnumerator
        /// <summary>
        /// tB[hvpeB񋓎q擾
        /// </summary>
        /// <remarks>Fields()Ɉڍs\</remarks>
        /// <returns>vpeB񋓎q</returns>
        public virtual IEnumerator<OFW.FieldProperties.FieldProperty> GetFields()
        {
            return null;
        }
        /// <summary>
        /// XVΏۃtB[hvpeB񋓎q擾
        /// </summary>
        /// <remarks>UpdateFields()Ɉڍs\</remarks>
        /// <returns>vpeB񋓎q</returns>
        public virtual IEnumerator<OFW.FieldProperties.FieldProperty> GetUpdateFields()
        {
            IEnumerator<OFW.FieldProperties.FieldProperty> enumerator = GetFields();
            foreach(OFW.FieldProperties.FieldProperty p in Fields())
            {
                if(enumerator.Current.DoUpdate) yield return enumerator.Current;

            }
        }
        /// <summary>
        /// L[vpeB񋓎q擾
        /// </summary>
        /// <remarks>PrimaryKeys()Ɉڍs\</remarks>
        /// <returns>vpeB񋓎q</returns>
        public virtual IEnumerator<OFW.FieldProperties.FieldProperty> GetPrimaryKeys()
        {
            //return null; //ꂾFields()ƂnullɂȂforeachłȂ
            yield break;

        }
        #endregion

        #region EntityProperty o

        /// <summary>
        /// GeBeB̖O(e[uȂ)
        /// </summary>
        public virtual string EntityName
        {
            get
            {
                return this.entityName;
            }
            set
            {
                this.entityName = value; ;
            }
        }

        /// <summary>
        /// XL[}
        /// </summary>
        public virtual string Schema
        {
            get
            {
                return this.schema;
            }
            set
            {
                this.schema = value;
            }
        }
        /// <summary>
        /// J^O(ʂɃf[^x[X)
        /// </summary>
        public virtual string Catalog
        {
            get
            {
                return this.catalog;
            }
            set
            {
                this.catalog= value;
            }
        }
        /// <summary>
        /// ʖ
        /// </summary>
        public virtual string Alias
        {
            get
            {
                return this.alias;
            }
            set
            {
                this.alias = value;
                foreach (FieldProperty p in Fields())
                {
                    p.TableName = this.alias == "" ? this.entityName: this.alias;
                }
            }
        }
        /// <summary>
        /// tl[
        /// </summary>
        public virtual string FullName
        {
            get
            {
                if (schema == "")
                {
                    return entityName;
                }
                else
                {
                    return schema + "." + entityName;
                }
            }
        }
        /// <summary>
        /// XV̗
        /// </summary>
        public virtual string ModifiedAtField
        {
            get
            {
                return this.modifiedAtField;
            }
            set
            {
                this.modifiedAtField = value;
            }
        }
        /// <summary>
        /// XV҂̗
        /// </summary>
        public virtual string ModifiedByField
        {
            get
            {
                return this.modifiedByField;
            }
            set
            {
                this.modifiedByField = value;
            }
        }
        /// <summary>
        /// 쐬̗
        /// </summary>
        public virtual string CreatedAtField
        {
            get
            {
                return this.createdAtField;
            }
            set
            {
                this.createdAtField = value;
            }
        }
        /// <summary>
        /// 쐬҂̗
        /// </summary>
        public virtual string CreatedByField
        {
            get
            {
                return this.createdByField;
            }
            set
            {
                this.createdByField = value;
            }
        }

        #endregion


        #region IEntityProperty o

        /// <summary>
        /// XVtB[h`FbN
        /// </summary>
        /// <param name="p"></param>
        /// <returns></returns>
        public bool IsModifiedAtField(OFW.FieldProperties.FieldProperty p)
        {
            return (p.FieldName == modifiedAtField);
        }
        /// <summary>
        /// 쐬tB[h`FbN
        /// </summary>
        /// <param name="p"></param>
        /// <returns></returns>
        public bool IsCreatedAtField(OFW.FieldProperties.FieldProperty p)
        {
            return (p.FieldName == createdAtField);
        }

        #endregion

        /// <summary>
        /// XVΏۈꊇݒ
        /// </summary>
        /// <param name="doUpdate"></param>
        public void SetDoUpdate(bool doUpdate)
        {
            foreach(FieldProperty p in Fields())
            {
                p.DoUpdate = doUpdate;
            }
        }
        /// <summary>
        /// XVΏۈꊇݒ
        /// </summary>
        public void SetDoUpdate()
        {
            SetDoUpdate(true);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public virtual object Clone()
        {
            return null;
        }
    }
}
