using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Util;
namespace OFW.Models
{
    /// <summary>
    /// treef[^̌B
    /// </summary>
    public class TreeNode : ITreeNode
    {
        /// <summary>
        /// id(DBo^pŁA[V`̊ȈՉׂ݂̈̂ɑ݂)
        /// </summary>
        protected int _id;
        /// <summary>
        /// id(DBo^pŁA[V`̊ȈՉׂ݂̈̂ɑ݂)
        /// </summary>
        public int id
        {
            get { return _id; }
            set { _id = value; }
        }
        ///<summary>m[hʂ閼O</summary>
        protected string _name;
        ///<summary>m[hʂ閼O</summary>
        public string name
        {
            get { return _name; }
            set { _name = value; }
        }

        List<TreeNode> _children;

        TreeNode _parent;


        /// <summary>
        /// 
        /// </summary>
        public bool hasChild
        {
            get
            {
                return _children.Count > 0;
            }
        }
        /// <summary>
        /// default construct 
        /// </summary>
        public TreeNode()
            : base()
        {
            this._name = "";
            _children = new List<TreeNode>();
            _parent = null;
        }
        #region ITreeNode o

        /// <summary>
        /// ̃IuWFNgwm[h̐cł邩
        /// </summary>
        /// <param name="target">Ώ</param>
        /// <returns>̃IuWFNgwm[h̐cł</returns>
        public bool isAncestorOf(OFW.Models.ITreeNode target)
        {
            return TreeNode.isAncestorOf(this, target);
        }

        /// <summary>
        /// ̃IuWFNgwm[h̎qł邩
        /// </summary>
        /// <param name="target">Ώ</param>
        /// <returns>̃IuWFNgwm[h̎qł邩</returns>
        public bool isDescendantOf(OFW.Models.ITreeNode target)
        {
            return TreeNode.isDescendantOf(this, target);
        }


        /// <summary>
        /// q
        /// </summary>
        public IEnumerable<ITreeNode> children
        {
            get
            {
                return _children.ToArray();
            }
            set
            {
                _children.Clear();
                IEnumerator<ITreeNode> e = value.GetEnumerator();
                while (e.MoveNext())
                {
                    _children.Add(e.Current as TreeNode);
                }
            }
        }
        /// <summary>
        /// 
        /// </summary>
        public ITreeNode parent
        {
            get
            {
                return _parent;
            }
            set
            {
                this._parent = value as TreeNode;
            }
        }
        /// <summary>
        /// append
        /// </summary>
        /// <param name="child"></param>
        public void appendChild(ITreeNode child)
        {
            _children.Add(child as TreeNode);
            child.parent = this;
        }
        /// <summary>
        /// remove
        /// </summary>
        /// <param name="child"></param>
        public void removeChild(ITreeNode child)
        {
            TreeNode childNode = child as TreeNode;
            int position = _children.FindIndex(delegate(TreeNode t) { return t.name == childNode.name; });
            if (position < 0)
            {
            }
            else
            {
                _children.RemoveAt(position);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        public string pathString
        {
            get { return TreeNode.createPathString(this); }
        }
        /// <summary>
        /// 
        /// </summary>
        public List<string> path
        {
            get { return TreeNode.createPath(this); }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public ITreeNode find(IEnumerable<string> path)
        {
            return TreeNode.find(this,path);
        }

        #endregion
        /// <summary>
        /// 
        /// </summary>
        /// <param name="tree"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static ITreeNode find(ITreeNode tree, IEnumerable<string> path)
        {
            ITreeNode target = null;
            ITreeNode current = tree;
            IEnumerator<string> e = path.GetEnumerator();
            while (e.MoveNext())
            {
                IEnumerator<ITreeNode> ee = current.children.GetEnumerator();
                while (ee.MoveNext())
                {
                    if (ee.Current.name == e.Current)
                    {
                        target = current;
                        continue;
                    }
                }
                break;
            }
            return target;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="tree"></param>
        /// <returns></returns>
        public static List<string> createPath(ITreeNode tree)
        {
            List<string> result = new List<string>();
            result.Add(tree.name);

            ITreeNode p = tree.parent;
            while (p != null)
            {
                if (p.name == "") break;
                result.Add(p.name);
                p = p.parent;
            }
            result.Reverse();
            return result;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="tree"></param>
        /// <returns></returns>
        public static string  createPathString(ITreeNode tree)
        {
            List<string> path = createPath(tree);
            string pathString = StringUtil.Join(path, "/");
            return pathString;
            
        }
        /// <summary>
        /// target  wm[h̐cł邩
        /// </summary>
        /// <param name="target">Ώ</param>
        /// <param name="node">Ώ</param>
        /// <returns>̃IuWFNgwm[h̐cł</returns>
        public static bool isAncestorOf(OFW.Models.ITreeNode target,OFW.Models.ITreeNode node)
        {
		    bool result = false;
		    ITreeNode p = node.parent;
		    while(p != null){
			    if(target.name == p.name){
				    result = true;
				    break;
			    }
			    p = p.parent;
		    }
		    return result;
        }
        /// <summary>
        /// target  wm[h̎qł邩
        /// </summary>
        /// <param name="target">Ώ</param>
        /// <param name="node">Ώ</param>
        /// <returns>̃IuWFNgwm[h̐cł</returns>
        public static bool isDescendantOf(OFW.Models.ITreeNode target, OFW.Models.ITreeNode node)
        {
            // nodetarget̐c = target  node ̎q
            return isAncestorOf(node,target);
        }
    }
}
