using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Newtonsoft.Json;

namespace OFW.Serializer.Drivers
{
    /// <summary>
    /// JSONVACỶ
    /// </summary>
    public class JSONSerializeDriver : SerializeDriver
    {
        /// <summary>
        /// ̃VACY(p~\)
        /// </summary>
        /// <param name="t"></param>
        /// <param name="writer"></param>
        /// <param name="o"></param>
        internal override void Serialize(Type t, TextWriter writer, object o)
        {
            JSONSerializer serializer = new JSONSerializer(t);
            writer.Write( serializer.Serialize(o) );
        }
        /// <summary>
        /// ̃fVACY(p~\)
        /// </summary>
        /// <param name="t"></param>
        /// <param name="reader"></param>
        /// <returns></returns>
        internal override object Deserialize(Type t, TextReader reader)
        {
            JSONSerializer serializer = new JSONSerializer(t);
            string s = reader.ReadToEnd();
            return serializer.Deserialize(s);
        }
    }
}
