using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using OFW.Util;
using Newtonsoft.Json;

namespace OFW.Serializer
{
    /// <summary>
    /// JSONVACY
    /// </summary>
    public class JSONSerializer
    {
        Type mType;
        JSONConverter mConverter;
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="t"></param>
        public JSONSerializer(Type t)
        {
            mType = t;
            mConverter = new JSONConverter(mType);
        }
        /// <summary>
        /// VACY
        /// </summary>
        /// <param name="o"></param>
        /// <returns></returns>
        public string Serialize(object o)
        {
            object jso = mConverter.CreateElementCore(o,mType);
            
            Newtonsoft.Json.JsonSerializer serializer = new JsonSerializer();
            StringWriter writer = new StringWriter();
            serializer.Serialize(new JsonWriter(writer),jso);

            return writer.ToString();
        }
        /// <summary>
        /// ŃVACY
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public object Deserialize(string s)
        {
            string normalized = StringUtil.Trim(s);
            Newtonsoft.Json.JsonSerializer serializer = new JsonSerializer();
            JavaScriptObject jso = serializer.Deserialize(new JsonReader(new StringReader(normalized))) as JavaScriptObject;
            return mConverter.ParseElementCore(jso,mType);

        }
    }
}
