using System;
using System.Globalization;
using Microsoft.VisualBasic;
using System.Text.RegularExpressions;

namespace OFW.Util
{
	/// <summary>
	/// DateUtil ̊Tv̐łB
	/// </summary>
	public class DateUtil
	{

        /// <summary>
        /// N邽߂̓
        /// </summary>
        public static int DaysToSuggestYear = -3;
        /// <summary>
        /// US\啶ɂ
        /// </summary>
        public static bool UseUpperCase = true;
        /// <summary>
        /// N\ɂ邽߂̔N
        /// </summary>
        public static int YearsForAgeByMonth = 2;
        /// <summary>
        /// jCfbNX̊Jn
        /// </summary>
        public static int WeekDayBase = 0;
        /// <summary>
        /// RXgN^
        /// </summary>
        private DateUtil()
		{
        }
        #region CX^X
        /// <summary>
        /// (܂܂Ȃ= 00)
        /// </summary>
        /// <returns>(܂܂Ȃ= 00)</returns>
        public static DateTime Today()
        {
            return DateTime.Today;
        }
        /// <summary>
        /// (܂)
        /// </summary>
        /// <returns>(܂)</returns>
        public static DateTime Now()
        {
            return DateTime.Now;
        }
        /// <summary>
        /// N_̊ɂt
        /// </summary>
        /// <returns>N_̊ɂt</returns>
        public static DateTime DateToSuggestYear()
        {
            return Today().AddDays(DaysToSuggestYear);
        }
        /// <summary>
        /// N_
        /// </summary>
        /// <returns>N_̊ɂtȍ~łƂ݂ɋ߂t</returns>
        public static DateTime InferYear(DateTime d)
        {
            if (d.CompareTo(DateToSuggestYear()) < 0)
            {
                return d.AddYears(1);
            }
            return d;
        }

        #endregion
        #region 
        /// <summary>
        /// NAA̗vft
        /// </summary>
        /// <param name="y">N킷l</param>
        /// <param name="m">킷l</param>
        /// <param name="d">킷l</param>
        /// <returns>wN琬t</returns>
        public static DateTime? Create(int y,int m,int d)
        {
            return new DateTime(y, m, d);
        }
        /// <summary>
        /// NA̗vft
        /// 1
        /// </summary>
        /// <param name="y">N킷l</param>
        /// <param name="m">킷l</param>
        /// <returns>wN{1̓t</returns>
        public static DateTime? CreateFromYearMonth(int y, int m)
        {
            return new DateTime(y, m, 1);
        }
        /// <summary>
        /// ̗vft
        /// N͊ȍ~̍ŏ̔N
        /// </summary>
        /// <param name="m">킷l</param>
        /// <param name="d">킷l</param>
        /// <returns>w茎łȍ~̓t</returns>
        public static DateTime? CreateFromMonthDay(int m, int d)
        {
            DateTime today = (DateTime)Today();
            DateTime newDate = new DateTime(today.Year,m,d);

            return InferYear(newDate);
        }
        #endregion
        #region ϊ
        /// <summary>
        /// DateTime҂lDateTime
        /// /// </summary>
        /// <param name="value">ϊΏۂ̕^̎</param>
        /// <returns>ϊt</returns>
        public static DateTime? DateValue(object value)
        {
            if (value == null) return null;
            if (value == DBNull.Value) return null;
            if (value.ToString().Trim() == "") return null;
            if (value is DateTime) return (DateTime)value;

            try
            {
                

                return Parse(value.ToString());
            }
            catch
            {
            }
            finally
            {
            }

            return null;
        }
        /// <summary>
        /// DateTime҂lt^ɕϊĕԂ
        /// </summary>
        /// <param name="value">ϊΏۂ̕^̎</param>
        /// <param name="formatString">͒l̏</param>
        /// <returns>null܂͕ϊʂDateTime</returns>
        [Obsolete]
        public static DateTime? DateValue(object value, string formatString)
        {
            return DateValue(value,formatString,CultureInfo.GetCultureInfo("ja-JP"));
        }
        /// <summary>
        /// DateTime҂lt^ɕϊĕԂ
        /// </summary>
        /// <param name="value">ϊΏۂ̕^̎</param>
        /// <param name="formatString">͒l̏</param>
        /// <param name="culture"></param>
        /// <returns>null܂͕ϊʂDateTime</returns>
        [Obsolete]
        public static DateTime? DateValue(object value, string formatString, CultureInfo culture)
        {
            if (value == null) return null;
            if (value == DBNull.Value) return null;
            if (value.ToString().Trim() == "") return null;
            if (value is DateTime) return (DateTime?)value;

            try
            {
                DateTime result = DateTime.ParseExact(value.ToString(), formatString, culture);
                return result;
            }
            catch
            {
            }
            finally
            {
            }

            return null;
        }
        /// <summary>
        /// ͂ēt^ɕϊ
        /// </summary>
        /// <param name="s">t`̕</param>
        /// <returns>͌ʂ̓tB̓G[̏ꍇnull</returns>
        public static DateTime? Parse(string s)
        {
            if(string.IsNullOrEmpty(s)) return null;

            //؂肠
            //yyyy/M/d H:m:s
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_LONG))
            {
                return Parse(s.Replace("-", "/"), DateTimeInputFormat.DATETIME_LONG);
            }
            //yyyy/M/d H:m
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_SMALL))
            {
                return Parse(s.Replace("-", "/"), DateTimeInputFormat.DATETIME_SMALL);
            }

            //yyyy/M/d
            if (Regex.IsMatch(s, RegExpFormat.DATE_LONG))
            {
                return Parse(s.Replace("-", "/"), DateTimeInputFormat.DATE_LONG);
            }
            //yy/M/d
            if (Regex.IsMatch(s, RegExpFormat.DATE_SHORT))
            {
                return Parse(s.Replace("-", "/"), DateTimeInputFormat.DATE_SHORT);
            }
            //؂Ȃ
            //yyyyMMddHHmmss
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_LONG_NO_DELIMITER))
            {
                return Parse(s, DateTimeInputFormat.DATETIME_LONG_NO_DELIMITER);
            }
            //yyyyMMddHHmm
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_SMALL_NO_DELIMITER))
            {
                return Parse(s, DateTimeInputFormat.DATETIME_SMALL_NO_DELIMITER);
            }
            //yyyyMMdd
            if (Regex.IsMatch(s, RegExpFormat.DATE_LONG_NO_DELIMITER))
            {
                return Parse(s, DateTimeInputFormat.DATE_LONG_NO_DELIMITER);
            }
            //yyMMdd
            if (Regex.IsMatch(s, RegExpFormat.DATE_SHORT_NO_DELIMITER))
            {
                return Parse(s, DateTimeInputFormat.DATE_SHORT_NO_DELIMITER);
            }
            //MMdd
            if (Regex.IsMatch(s, RegExpFormat.DATE_MONTH_DAY_NO_DELIMITER))
            {
                if (s.Length < 4) s = "0" + s;
                return Parse(s, DateTimeInputFormat.MONTHDAY_NO_DELIMITER);
            }
            //MM/dd
            if (Regex.IsMatch(s, RegExpFormat.DATE_MONTH_DAY))
            {
                return Parse(s, DateTimeInputFormat.MONTHDAY);
            }
            DateTime d;
            if (DateTime.TryParse(s, out d))
            {
                return d;
            }
            return null;
        }
        /// <summary>
        /// ͂BN AD 1/JAN/01 ŒB
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public static DateTime? ParseTime(string s)
        {
            int hour= 0;
            int minute= 0;
            int second= 0;
            int millisecond = 0;
            if (Regex.IsMatch(s, RegExpFormat.TIME_LONG))
            {
                string[] elements = StringUtil.Split(s,":");
                hour = NumberUtil.Value<int>( elements[0] );
                minute = NumberUtil.Value<int>(elements[1]);
                second = NumberUtil.Value<int>(elements[2]);
                return CreateTime(hour, minute, second, millisecond);
            }
            if (Regex.IsMatch(s, RegExpFormat.TIME_SMALL))
            {
                string[] elements = StringUtil.Split(s, ":");
                hour = NumberUtil.Value<int>(elements[0]);
                minute = NumberUtil.Value<int>(elements[1]);
                return CreateTime(hour, minute, second, millisecond);
            }
            if (Regex.IsMatch(s, RegExpFormat.TIME_LONG_NO_DELIMITER))
            {
                string timeString = StringUtil.Right("0" + s, 6);
                hour = NumberUtil.Value<int>(timeString.Substring(0,2));
                minute = NumberUtil.Value<int>(timeString.Substring(2, 2));
                second = NumberUtil.Value<int>(timeString.Substring(4, 2));
                return CreateTime(hour, minute, second, millisecond);
            }
            if (Regex.IsMatch(s, RegExpFormat.TIME_SMALL_NO_DELIMITER))
            {
                string timeString = StringUtil.Right("0" + s, 4);
                hour = NumberUtil.Value<int>(timeString.Substring(0, 2));
                minute = NumberUtil.Value<int>(timeString.Substring(2, 2));
                return CreateTime(hour, minute, second, millisecond);
            }
            if (Regex.IsMatch(s, RegExpFormat.TIME_HOUR_ONLY))
            {
                hour = NumberUtil.Value<int>(s);
                return CreateTime(hour, minute, second, millisecond);
            }
            if (Regex.IsMatch(s, RegExpFormat.TIME_FULL))
            {
                int fractionPosition = s.IndexOf(".");
                string[] elements = StringUtil.Split( s.Substring(0,fractionPosition),":");
                hour = NumberUtil.Value<int>(elements[0]);
                minute = NumberUtil.Value<int>(elements[1]);
                second = NumberUtil.Value<int>(elements[2]);
                millisecond = NumberUtil.Value<int>(StringUtil.Left(s.Substring(fractionPosition + 1), 3));
                return CreateTime(hour, minute, second, millisecond);
            }
            return null;

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="h"></param>
        /// <param name="m"></param>
        /// <param name="s"></param>
        /// <param name="f"></param>
        /// <returns></returns>
        public static DateTime? CreateTime(int h, int m, int s,int f)
        {
            DateTime d = new DateTime(1, 1, 1, h, m, s, f);
            return d;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="s"></param>
        /// <param name="formatString"></param>
        /// <returns></returns>
        public static DateTime? Parse(string s, string formatString)
        {
            return Parse(s, formatString, CultureInfo.GetCultureInfo("ja-JP"));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="s"></param>
        /// <param name="formatString"></param>
        /// <param name="culture"></param>
        /// <returns></returns>
        public static DateTime? Parse(string s, string formatString, CultureInfo culture)
        {
            try
            {
                DateTime result = DateTime.ParseExact(s, formatString, culture);
                return result;
            }
            catch
            {
            }
            finally
            {
            }

            return null;
        }

        /// <summary>
        /// t+͂̕ēt^ɕϊ
        /// </summary>
        /// <param name="s">t`̕</param>
        /// <returns>͌ʂ̓tB̓G[̏ꍇnull</returns>
        public static DateTime? ParseLongDateTime(string s)
        {
            //؂肠
            //yyyy/M/d H:m:s
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_LONG))
            {
                return Parse(s.Replace("-", "/"), DateTimeInputFormat.DATETIME_LONG);
            }
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_SMALL))
            {
                //b͂ȗꍇ
                return Parse(s.Replace("-", "/"), DateTimeInputFormat.DATETIME_SMALL);
            }
            if (Regex.IsMatch(s, RegExpFormat.DATE_LONG))
            {
                //͂ȗꍇ
                return Parse(s.Replace("-", "/"), DateTimeInputFormat.DATE_LONG);
            }
            //؂Ȃ
            //yyyyMMddHHmmss
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_LONG_NO_DELIMITER))
            {
                return Parse(s, DateTimeInputFormat.DATETIME_LONG_NO_DELIMITER);
            }
            //yyyyMMddHHmm
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_SMALL_NO_DELIMITER))
            {
                //bȗ
                return Parse(s, DateTimeInputFormat.DATETIME_SMALL_NO_DELIMITER);
            }
            //yyyyMMdd
            if (Regex.IsMatch(s, RegExpFormat.DATE_LONG_NO_DELIMITER))
            {
                //ȗ
                return Parse(s, DateTimeInputFormat.DATE_LONG_NO_DELIMITER);
            }
            return null;
        }
        /// <summary>
        /// ͂ēt^ɕϊ
        /// </summary>
        /// <param name="s">t`̕</param>
        /// <returns>͌ʂ̓tB̓G[̏ꍇnull</returns>
        public static DateTime? ParseSmallDateTime(string s)
        {
            DateTime? parsed = null;
            //؂肠
            //yyyy/M/d H:m:s
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_LONG))
            {
                int lastcolon = s.LastIndexOf(":");
                parsed = Parse(s.Replace("-", "/").Substring(0, lastcolon), DateTimeInputFormat.DATETIME_SMALL);
            }
            else if (Regex.IsMatch(s, RegExpFormat.DATETIME_SMALL))
            {
                //b͂ȗꍇ
                parsed = Parse(s.Replace("-", "/"), DateTimeInputFormat.DATETIME_SMALL);
            }
            else if (Regex.IsMatch(s, RegExpFormat.DATE_LONG))
            {
                //͂ȗꍇ
                parsed = Parse(s.Replace("-", "/"), DateTimeInputFormat.DATE_LONG);
            }
            //؂Ȃ
            //yyyyMMddHHmmss
            else if (Regex.IsMatch(s, RegExpFormat.DATETIME_LONG_NO_DELIMITER))
            {
                parsed = Parse(s.Substring(0, 12), DateTimeInputFormat.DATETIME_SMALL_NO_DELIMITER);
            }
            //yyyyMMddHHmm
            else if (Regex.IsMatch(s, RegExpFormat.DATETIME_SMALL_NO_DELIMITER))
            {
                //bȗ
                parsed = Parse(s, DateTimeInputFormat.DATETIME_SMALL_NO_DELIMITER);
            }
            //yyyyMMdd
            else if (Regex.IsMatch(s, RegExpFormat.DATE_LONG_NO_DELIMITER))
            {
                //ȗ
                parsed = Parse(s, DateTimeInputFormat.DATE_LONG_NO_DELIMITER);
            }

            return parsed;
        }
        /// <summary>
        /// t͂ēt^ɕϊ
        /// </summary>
        /// <param name="s">t`̕</param>
        /// <returns>͌ʂ̓tB̓G[̏ꍇnull</returns>
        public static DateTime? ParseLongDate(string s)
        {
            DateTime? parsed = null;
            //؂肠
            //yyyy/M/d H:m:s
            if (Regex.IsMatch(s, RegExpFormat.DATETIME_LONG))
            {
                int lastcolon = s.LastIndexOf(" ");
                parsed = Parse(s.Replace("-", "/").Substring(0, lastcolon), DateTimeInputFormat.DATETIME_LONG);
            }
            else if (Regex.IsMatch(s, RegExpFormat.DATETIME_SMALL))
            {
                //b͂ȗꍇ
                int lastcolon = s.LastIndexOf(" ");
                parsed = Parse(s.Replace("-", "/"), DateTimeInputFormat.DATETIME_SMALL);
            }
            else if (Regex.IsMatch(s, RegExpFormat.DATE_LONG))
            {
                //͂ȗꍇ
                parsed = Parse(s.Replace("-", "/"), DateTimeInputFormat.DATE_LONG);
            }
            //؂Ȃ
            //yyyyMMddHHmmss
            else if (Regex.IsMatch(s, RegExpFormat.DATETIME_LONG_NO_DELIMITER))
            {
                parsed = Parse(s.Substring(0, 8), DateTimeInputFormat.DATETIME_LONG_NO_DELIMITER);
            }
            //yyyyMMddHHmm
            else if (Regex.IsMatch(s, RegExpFormat.DATETIME_SMALL_NO_DELIMITER))
            {
                //bȗ
                parsed = Parse(s.Substring(0, 8), DateTimeInputFormat.DATETIME_SMALL_NO_DELIMITER);
            }
            //yyyyMMdd
            else if (Regex.IsMatch(s, RegExpFormat.DATE_LONG_NO_DELIMITER))
            {
                //ȗ
                parsed = Parse(s, DateTimeInputFormat.DATE_LONG_NO_DELIMITER);
            }

            return parsed;
        }
        /// <summary>
        /// t͂ēt^ɕϊ
        /// </summary>
        /// <param name="s">t`̕</param>
        /// <returns>͌ʂ̓tB̓G[̏ꍇnull</returns>
        public static DateTime? ParseShortDate(string s)
        {
            DateTime? parsed = null;
            //؂肠
            //yy/M/d
            if (Regex.IsMatch(s, RegExpFormat.DATE_SHORT))
            {
                //͂ȗꍇ
                parsed = Parse(s.Replace("-", "/"), DateTimeInputFormat.DATE_LONG);
            }
            //yyyyMMdd
            else if (Regex.IsMatch(s, RegExpFormat.DATE_SHORT_NO_DELIMITER))
            {
                //ȗ
                parsed = Parse(s, DateTimeInputFormat.DATE_SHORT_NO_DELIMITER);
            }

            return parsed;
        }

        /// <summary>
        /// ̂ĂB
        /// </summary>
        /// <param name="o"></param>
        /// <returns>wt00\t</returns>
        public static DateTime? TruncateTime(object o)
        {
            if (o == null) return null;
            DateTime d = (DateTime)o;
            return new DateTime(d.Year, d.Month, d.Day);

        }
        /// <summary>
        /// AJX^C(01JANȂ)͂ēt^ɕϊB
        /// N͊ȍ~̍ŏ̓
        /// </summary>
        /// <param name="s">t`̕</param>
        public static DateTime? ParseDayMonthAbbr(string s)
        {
            DateTime? d = Parse(s, DateTimeInputFormat.DAYMONTH_ABBR, Util.USCulture());
            if (d == null) return null;

            return InferYear(d.Value);

        }
        /// <summary>
        /// AJX^CN(01JAN2001Ȃ)͂ēt^ɕϊB
        /// </summary>
        /// <param name="s">t`̕</param>
        public static DateTime? ParseDayMonthYearAbbr(string s)
        {
            DateTime? d = Parse(s, DateTimeInputFormat.DAYMONTHYEAR_ABBR, Util.USCulture());
            if (d == null) return null;

            return d.Value;

        }
        /// <summary>
        /// AJX^CN(31/12/99Ȃ)͂ēt^ɕϊB
        /// </summary>
        /// <param name="s">t`̕</param>
        public static DateTime? ParseDayMonthYearShort(string s)
        {
            //dd/MM/yy
            if (Regex.IsMatch(s, @"\d\d[/\-]\d\d[/\-]\d\d"))
            {
                //ȗ
                return Parse(s, DateTimeInputFormat.DAYMONTHYEAR_SHORT);
            }
            if (Regex.IsMatch(s, @"\d\d\d\d\d\d"))
            {
                //ȗ
                return Parse(s, DateTimeInputFormat.DAYMONTHYEAR_SHORT_NO_DELIMITER);
            }

            return null;
        }
        /// <summary>
        /// t(M/d)͂ēt^ɕϊ
        /// </summary>
        /// <param name="s">t`̕</param>
        /// <returns></returns>
        public static DateTime? ParseMonthDay(string s)
        {
            DateTime? parsed = null;
            //؂肠
            //yy/M/d
            if (Regex.IsMatch(s, RegExpFormat.DATE_MONTH_DAY))
            {
                parsed = Parse(s.Replace("-", "/"), DateTimeInputFormat.MONTHDAY);
            }
            //yyyyMMdd
            else if (Regex.IsMatch(s, RegExpFormat.DATE_MONTH_DAY_NO_DELIMITER))
            {
                parsed = Parse(s, DateTimeInputFormat.MONTHDAY_NO_DELIMITER);
            }

            return parsed;
        }

        #endregion
        #region vZ
        /// <summary>
        /// tvZ
        /// </summary>
        /// <param name="date">vZ̊</param>
        /// <param name="diff">ZAAN</param>
        /// <param name="unit">Pʂ킷 y,m,d</param>
        /// <returns>Z</returns>
        public static DateTime AddDate(DateTime date,int diff,string unit)
        {
                DateTime d = date;
                if (unit.ToLower() == "y")
                {
                    d = d.AddYears(diff);
                }
                else if (unit.ToLower() == "m")
                {
                    d = d.AddMonths(diff);
                }
                else if (unit.ToLower() == "d")
                {
                    d = d.AddDays(diff);
                }

                return d;

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="year">N</param>
        /// <param name="month"></param>
        /// <param name="after">Z錎</param>
        /// <returns>wNafteř</returns>
        public static DateTime? MonthAfter(int year,int month,int after)
        {
            if (year < 0) return null;
            if (month < 1) return null;
            if (month > 12) return null;

            DateTime baseDate = (DateTime) CreateFromYearMonth(year,month);
            return baseDate.AddMonths(after);

        }
        /// <summary>
        /// ̌
        /// </summary>
        /// <param name="year">N</param>
        /// <param name="month"></param>
        /// <param name="after">Z錎</param>
        /// <returns>wNafteř</returns>
        public static DateTime? EndOfMonthAfter(int year, int month, int after)
        {
            return EndOfMonth(MonthAfter(year,month,after));

        }
        /// <summary>
        /// w̌̌
        /// </summary>
        /// <param name="d">wt</param>
        /// <returns>wť̌</returns>
        public static DateTime? EndOfMonth(object d)
        {
            if (d == null) return null;
            DateTime next = ((DateTime)d).AddMonths(1);
            int days = next.Day;

            return next.AddDays(-days);

        }
        /// <summary>
        /// w茎̌
        /// </summary>
        /// <param name="y">wN</param>
        /// <param name="m">w茎</param>
        /// <returns>wŇ</returns>
        public static DateTime? EndOfMonth(int y,int m)
        {
            DateTime next = (CreateFromYearMonth(y,m)).Value.AddMonths(1);
            int days = next.Day;

            return next.AddDays(-days);

        }
        /// <summary>
        /// `FbN
        /// </summary>
        /// <param name="d">wt</param>
        /// <returns>Ȃtrue</returns>
        public static bool IsEndOfMonth(object d)
        {
            if (d == null) return false;
            DateTime end = (DateTime) EndOfMonth(d);
            return ((DateTime)d).CompareTo(end) == 0;
        }
        /// <summary>
        /// Z
        /// </summary>
        /// <param name="d">t</param>
        /// <param name="days">Z</param>
        /// <returns>Z̓t</returns>
        public static DateTime? AddDays(object d,int days)
        {
            if (d == null) return null;
            DateTime next = ((DateTime)d).AddDays(days);

            return next;

        }
        /// <summary>
        /// Z
        /// </summary>
        /// <param name="d">t</param>
        /// <param name="months">Z</param>
        /// <returns>Z̓t</returns>
        public static DateTime? AddMonths(object d, int months)
        {
            if (d == null) return null;
            DateTime next = ((DateTime)d).AddMonths(months);

            return next;

        }
        /// <summary>
        /// NZ
        /// </summary>
        /// <param name="d">t</param>
        /// <param name="years">ZN</param>
        /// <returns>Z̓t</returns>
        public static DateTime? AddYears(object d, int years)
        {
            if (d == null) return null;
            DateTime next = ((DateTime)d).AddYears(years);

            return next;

        }
        /// <summary>
        /// vZ
        /// </summary>
        /// <param name="d1"></param>
        /// <param name="d2">rΏۓ</param>
        /// <returns>rΏۓ܂ł̓</returns>
        public static int DiffDays(object d1, object d2) 
        {
            long diff = Microsoft.VisualBasic.DateAndTime.DateDiff(DateInterval.Day, (DateTime)d1, (DateTime)d2,FirstDayOfWeek.Sunday,FirstWeekOfYear.Jan1);
            //longŕԂ邪ȂɗvȂB
            if (diff > (long)Int32.MaxValue) return 0;
            int intDiff = (int)diff;
            return intDiff;
        }
        /// <summary>
        /// ̌
        /// </summary>
        /// <param name="year">N</param>
        /// <param name="month"></param>
        /// <returns>wN̗̂P</returns>
        public static DateTime? NextMonth(int year, int month)
        {
            return AddMonths(CreateFromYearMonth(year, month), 1);
        }
        /// <summary>
        /// Ǒ
        /// </summary>
        /// <param name="year"></param>
        /// <param name="month"></param>
        /// <returns></returns>
        public static DateTime? PreviousMonth(int year, int month)
        {
            return AddMonths(CreateFromYearMonth(year, month), -1);
        }
        /// <summary>
        /// N
        /// </summary>
        /// <param name="birthday">a</param>
        /// <param name="baseDate"></param>
        /// <returns>N</returns>
        public static int AgeYear(object birthday, object baseDate)
        {
            if (birthday == null) return 0;
            if (baseDate == null) return 0;
            DateTime d = (DateTime)birthday;
            DateTime x = (DateTime)baseDate;

            return x.Year - d.Year
                - (((d.Month * 100 + d.Day) > (x.Month * 100 + x.Day)) ? 1 : 0);

        }
        /// <summary>
        /// N()
        /// </summary>
        /// <param name="birthday">a</param>
        /// <param name="baseDate"></param>
        /// <returns>N(P)</returns>
        public static int AgeMonth(object birthday, object baseDate)
        {
            if (birthday == null) return 0;
            if (baseDate == null) return 0;
            DateTime d = (DateTime)birthday;
            DateTime x = (DateTime)baseDate;

            return ((x.Year - d.Year) * 12) + x.Month - d.Month
                - ((d.Day > x.Day) ? 1 : 0);

        }
        /// <summary>
        /// ƐN99Yi24ȏj܂99MiQSj̕𓾂
        /// </summary>
        /// <param name="birthday">a</param>
        /// <param name="baseDate"></param>
        public static string AgeString(object birthday, object baseDate)
        {
            string s = "";
            int age = AgeYear(birthday, baseDate);
            if (age < YearsForAgeByMonth)
            {
                s = AgeMonth(birthday,baseDate).ToString() + "M";
            }
            else
            {
                s = age.ToString() + "Y";
            }
            return string.Format("{0,3}",s);
        }
        /// <summary>
        /// ƐN99΂܂99iQSj̕𓾂
        /// </summary>
        /// <param name="birthday">a</param>
        /// <param name="baseDate"></param>
        public static string AgeStringJP(object birthday, object baseDate)
        {
            string s = "";
            int age = AgeYear(birthday, baseDate);
            if (age < YearsForAgeByMonth)
            {
                s = AgeMonth(birthday, baseDate).ToString() + "";
            }
            else
            {
                s = age.ToString() + "";
            }
            return string.Format("{0,3}", s);
        }
        /// <summary>
        /// j̃CfbNX(WeekDayBasen܂)
        /// </summary>
        /// <param name="o">wt</param>
        /// <returns>j̃CfbNX</returns>
        public static int DayOfWeekIndex(object o)
        {
            if (o == null) return WeekDayBase - 1;
            int index = (int)((DateTime)o).DayOfWeek;
            return index + WeekDayBase;
        }
        /// <summary>
        /// j
        /// </summary>
        /// <param name="o">wt</param>
        /// <returns>wt̗j</returns>
        public static string DayOfWeekString(object o)
        {
            if (o == null) return "";
            string result = Format(o,"ddd",Util.USCulture());
            return (UseUpperCase) ? result.ToUpper() : result;
        }
        /// <summary>
        /// j
        /// </summary>
        /// <param name="o">wt</param>
        /// <returns>wt̗j</returns>
        public static string DayOfWeekStringJP(object o)
        {
            if (o == null) return "";
            string result = Format(o, "ddd", Util.JPCulture());
            return (UseUpperCase) ? result.ToUpper() : result;
        }
        #endregion
        #region `FbNAeXgA
        /// <summary>
        /// ͈̓`FbN
        /// 
        /// {Iȓt͈(100NO100N܂)؂B
        /// </summary>
        /// <param name="o">Ώۓt</param>
        /// <returns>Ώۓtt͈(100NO100N܂)ɂTrue,łȂFalse</returns>
        public static bool IsValidRange(object o)
        {
            try
            {
                DateTime target = (DateTime)o;
                DateTime min = DateTime.Today.AddYears(-100);
                DateTime max = DateTime.Today.AddYears(100);

                if (target.CompareTo(min) < 0) return false;
                if (target.CompareTo(max) > 0) return false;

                return true;

            }
            catch (Exception)
            {
                return false;
            }
            
        }
        /// <summary>
        /// ͈͂̐
        /// </summary>
        /// <param name="o">؂Ώ</param>
        /// <param name="min">͈(ŏl)</param>
        /// <param name="max">͈(ől)</param>
        /// <returns>͈͂Ȃtrue,łȂfalse</returns>
        public static bool IsInRange(object o,object min,object max)
        {
            if (o == null) return false;
            if ((min == null) && (max == null)) return false;

            DateTime target = (DateTime)o;

            if (min == null)
            {
                if (target.CompareTo(max) > 0) return false;
            }
            else if (max == null)
            {
                if (target.CompareTo(min) < 0) return false;
            }
            else
            {
                if (target.CompareTo(min) < 0) return false;
                if (target.CompareTo(max) > 0) return false;
            }
            return true;

        }
        /// <summary>
        /// ͈͂̐
        /// </summary>
        /// <param name="o">؂Ώ</param>
        /// <param name="min">͈(ŏl)</param>
        /// <param name="max">͈(ől)</param>
        /// <returns>͈͂Ȃtrue,łȂfalse</returns>
        public static bool IsBetween(object o, object min, object max)
        {
            return IsInRange(o, min, max);
        }
        /// <summary>
        /// wO
        /// </summary>
        /// <param name="d1">Ώۓ</param>
        /// <param name="d2"></param>
        /// <returns>ΏۓOȂtrue</returns>
        public static bool IsBefore(object d1, object d2)
        {
            if (d1 == null) return false;
            if (d2 == null) return false;

            return DateTime.Compare((DateTime)d1, (DateTime)d2) < 0;
        }
        /// <summary>
        /// wO
        /// </summary>
        /// <param name="d1">Ώۓ</param>
        /// <param name="d2"></param>
        /// <returns>ΏۓOȂtrue</returns>
        public static bool IsBeforeOrSame(object d1, object d2)
        {
            if (d1 == null) return false;
            if (d2 == null) return false;

            return DateTime.Compare((DateTime)d1, (DateTime)d2) <= 0;
        }
        /// <summary>
        /// wォ
        /// </summary>
        /// <param name="d1">Ώۓ</param>
        /// <param name="d2"></param>
        /// <returns>ΏۓȂtrue</returns>
        public static bool IsAfter(object d1, object d2)
        {
            if (d1 == null) return false;
            if (d2 == null) return false;

            return DateTime.Compare((DateTime)d1, (DateTime)d2) > 0;
        }
        /// <summary>
        /// wォ
        /// </summary>
        /// <param name="d1">Ώۓ</param>
        /// <param name="d2"></param>
        /// <returns>ΏۓォȂtrue</returns>
        public static bool IsAfterOrSame(object d1, object d2)
        {
            if (d1 == null) return false;
            if (d2 == null) return false;

            return DateTime.Compare((DateTime)d1, (DateTime)d2) >= 0;
        }
        /// <summary>
        /// wƓ
        /// </summary>
        /// <param name="d1">Ώۓ</param>
        /// <param name="d2"></param>
        /// <returns>ΏۓƓȂtrue</returns>
        public static bool IsSame(object d1, object d2)
        {
            if (d1 == null) return false;
            if (d2 == null) return false;

            return DateTime.Compare((DateTime)d1, (DateTime)d2) == 0;
        }

        #endregion
        #region 
        /// <summary>
        /// WtH[}bg
        /// </summary>
        /// <param name="d">wt</param>
        /// <returns>tH[}bgʕ</returns>
        public static string Format(object d)
        {
            if (d == null) return "";
            return d.ToString();
        }
        /// <summary>
        /// w菑w蕶ɏ]ēt^𕶎^ɕϊĕԂ
        /// </summary>
        /// <remarks>
        /// nullnꂽ󕶎Ԃ
        /// t^ł͂ȂA܂͓t̕\ł͂ȂȂ͒l̕\Ԃ
        /// </remarks>
        /// <param name="value">ϕϊΏۂ̓t^̎</param>
        /// <param name="format"></param>
        /// <returns>tH[}bg</returns>
        public static string Format(object value, string format)
        {
            if (value == null) return "";

            DateTime dt = (DateTime)value;
            return dt.ToString(format);
        }
        /// <summary>
        /// w菑w蕶ɏ]ēt^𕶎^ɕϊĕԂ
        /// </summary>
        /// <remarks>
        /// nullnꂽ󕶎Ԃ
        /// t^ł͂ȂA܂͓t̕\ł͂ȂȂ͒l̕\Ԃ
        /// </remarks>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <param name="format"></param>
        /// <param name="culture"></param>
        /// <returns>tH[}bg</returns>
        public static string Format(object value, string format, CultureInfo culture)
        {
            if (value == null) return "";

            try
            {
                DateTime dt = (DateTime)value;
                return dt.ToString(format,culture.DateTimeFormat);
            }
            catch
            {
            }
            finally
            {
            }

            return "";
        }
        /// <summary>
        /// yyyy/MM/dd`ŏ
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns>tH[}bg</returns>
        public static string FormatLongDate(object value)
        {
            return Format(value, DateTimeOutputFormat.LONG_DATE);
        }
        /// <summary>
        /// yyyyMMdd`ŏ(؂XbVȂ)
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static string FormatLongDateNoDelimiter(object value)
        {
            return Format(value, DateTimeOutputFormat.LONG_DATE_NO_DELIMITER);
        }
        /// <summary>
        /// yyyy/MM/dd HH:mm:ss `ŏ 
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns>tH[}bg</returns>
        public static string FormatLongDateTime(object value)
        {
            return Format(value, DateTimeOutputFormat.LONG_DATETIME);
        }
        /// <summary>
        /// yyyyMMddHHmmss`ŏ
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns>tH[}bg</returns>
        public static string FormatLongDateTimeNoDelimiter(object value)
        {
            return Format(value, DateTimeOutputFormat.LONG_DATETIME_NO_DELIMITER);
        }
        /// <summary>
        /// yyyy/MM/dd HH:mm`ŏ
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns></returns>
        public static string FormatSmallDateTime(object value)
        {
            return Format(value, DateTimeOutputFormat.SMALL_DATETIME);
        }
        /// <summary>
        /// yyyyMMddHHmm`ŏ
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns>tH[}bg</returns>
        public static string FormatSmallDateTimeNoDelimiter(object value)
        {
            return Format(value, DateTimeOutputFormat.SMALL_DATETIME_NO_DELIMITER);
        }
        /// <summary>
        /// ddMMMyyyy`ŏ
        /// 
        /// 03Mar2004ȂǁB
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns>tH[}bg</returns>
        public static string FormatDayMonthYearAbbr(object value)
        {
            string result = Format(value, DateTimeOutputFormat.DAY_MONTH_YEAR_ABBR,Util.USCulture());
            if (UseUpperCase) return result.ToUpper();
            return result;
        }
        /// <summary>
        /// ddMMM`ŏ
        /// 
        /// 03MarȂ
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns>tH[}bg</returns>
        public static string FormatDayMonthAbbr(object value)
        {
            string result = Format(value, DateTimeOutputFormat.DAY_MONTH_ABBR, Util.USCulture());
            if (UseUpperCase) return result.ToUpper();
            return result;
        }
        /// <summary>
        /// MM/dd`ŏ
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns>tH[}bg</returns>
        public static string FormatMonthDay(object value)
        {
            string result = Format(value, DateTimeOutputFormat.MONTH_DAY);
            return result;
        }
        /// <summary>
        /// MMdd`ŏ
        /// </summary>
        /// <param name="value">Ώۂ̓t^̎</param>
        /// <returns>tH[}bg</returns>
        public static string FormatMonthDayNoDelimiter(object value)
        {
            string result = Format(value, DateTimeOutputFormat.MONTH_DAY_NO_DELIMITER);
            return result;
        }
        #endregion

    }
}
