using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
namespace OFW.Util
{
    /// <summary>
    /// ̃g[N
    /// </summary>
    public class StringTokenizer
    {
        /// <summary>
        /// ̏I
        /// </summary>
        const int EOF = -1;
        /// <summary>
        /// ǎ摕u
        /// </summary>
        TextReader reader;
        /// <summary>
        /// ݂̓ǎʒu̕
        /// </summary>
        int c;
        /// <summary>
        /// ݓǂݎ蒆̃g[N
        /// </summary>
        string token;
        /// <summary>
        /// 镶
        /// </summary>
        int[] ignore = new int[] { ' ', '\t', '\r', '\n' };
        /// <summary>
        /// L
        /// </summary>
        int[] delimiters = new int[] { ' ', '\t', '\r', '\n' };
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="reader">ǂݎ茳</param>
        public StringTokenizer(TextReader reader)
        {
            this.reader = reader;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="s">ǂݎ茳</param>
        public StringTokenizer(string s)
        {
            this.reader = new StringReader(s);
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="s">ǂݎ茳</param>
        /// <param name="delimiters">L</param>
        public StringTokenizer(string s,int[] delimiters)
        {
            this.reader = new StringReader(s);
            this.delimiters = delimiters;
            this.ignore = (int[]) this.delimiters.Clone();
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="s">ǂݎ茳</param>
        /// <param name="delimiters">L</param>
        /// <param name="ignores">ǂݎ̂Ă镶</param>
        public StringTokenizer(string s, int[] delimiters, int[] ignores)
        {
            this.reader = new StringReader(s);
            this.delimiters = delimiters;
            this.ignore = ignores;
        }

        /// <summary>
        /// ܂g[NcĂ邩
        /// </summary>
        /// <returns></returns>
        public bool HasMoreTokens()
        {
            return (this.c != EOF);

        }
        /// <summary>
        /// ̃g[N擾
        /// </summary>
        /// <returns></returns>
        public string NextToken()
        {
            if (this.c == EOF)
            {
                this.token = null;
                return this.token;
            }

            //镶Ȃǂݔ΂
            this.SkipIgnoreChars();

            //token̉ĕԂ
            StringBuilder tokenBuilder = new StringBuilder();

            while (this.c != EOF)
            {

                if (this.IsDelimiter())
                {
                    this.c = this.reader.Read();
                    break;
                }

                tokenBuilder.Append(new string((char)this.c, 1));
                this.c = this.reader.Read();

            }

            this.token = tokenBuilder.ToString();
            return this.token;

        }
        /// <summary>
        /// 镶͓ǂݎ̂Ă
        /// </summary>
        void SkipIgnoreChars()
        {
            while (this.c != EOF)
            {
                if (!this.IsIgnoreChar())
                {
                    break;
                }
                this.c = this.reader.Read();
            }
        }
        /// <summary>
        /// ݂̕
        /// </summary>
        /// <returns></returns>
        bool IsIgnoreChar()
        {
            bool found = false;
            foreach (int ch in this.ignore)
            {
                if (ch == this.c)
                {
                    found = true;
                    break;
                }
            }
            return found;
        }
        /// <summary>
        /// ݂̕L
        /// </summary>
        /// <returns></returns>
        bool IsDelimiter()
        {
            bool found = false;
            foreach (int ch in this.delimiters)
            {
                if (ch == this.c)
                {
                    found = true;
                    break;
                }
            }
            return found;
        }

    }
}
