using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using OFW.ErrorHandler;

namespace OFW.Util
{
    /// <summary>
    /// xml
    /// </summary>
    public class XmlUtil
    {
        /// <summary>
        /// xml𕶎񂩂烍[h
        /// </summary>
        /// <param name="xmlString"></param>
        /// <returns></returns>
        public static XmlDocument LoadXml(string xmlString)
        {
            try
            {
                XmlDocument doc = new XmlDocument();
                doc.LoadXml(xmlString);

                return doc;
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
            }
            return null;            
        }
        /// <summary>
        /// wm[h̎qpathŒ`ꂽm[h邩eXg
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static bool NodeExists(XmlNode node, string path)
        {
            XmlNodeList list = node.SelectNodes(path);
            if (list == null) return false;
            if (list.Count == 0) return false;

            return true;
        }
        /// <summary>
        /// wm[h̃eLXg擾
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public static string GetText(XmlNode node)
        {
            if (node == null)
            {
                throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
            }
            try
            {
                string text = "";
                XmlNode fixedNode = FixNode(node);
                switch(fixedNode.NodeType){
                    case XmlNodeType.CDATA:
                        text = fixedNode.Value;
                        break;
                    case XmlNodeType.Text:
                        text = fixedNode.Value;
                        break;
                    case XmlNodeType.Attribute:
                        text = fixedNode.Value;
                        break;
                    default:
                        text = fixedNode.InnerText;
                        break;
                }
                return text;
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }
        /// <summary>
        /// wm[h̎qvfpathŎw肳ꂽm[hTēeLXgԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static string GetText(XmlNode node, string path)
        {
            if (node == null)
            {
                throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
            }
            try
            {
                XmlNode target = node.SelectSingleNode(path);
                if (target == null)
                {
                    throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
                }

                return GetText(target);
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }
        /// <summary>
        /// ݒ肳Ă邩킩Ȃm[h̃eLXg擾
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public static string GetTextOptional(XmlNode node)
        {
            return GetTextOptionalDefault(node, "");
        }
        /// <summary>
        /// ݒ肳Ă邩킩Ȃm[h̃eLXg擾
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static string GetTextOptional(XmlNode node,string path)
        {
            return GetTextOptionalDefault(node, path, "");
        }
        /// <summary>
        /// ݒ肳Ă邩킩Ȃm[h̃eLXg擾
        /// </summary>
        /// <param name="node"></param>
        /// <param name="defaultValue"></param>
        /// <returns></returns>
        public static string GetTextOptionalDefault(XmlNode node, string defaultValue)
        {
            if (node == null) return defaultValue;
            return GetText(node);
        }
        /// <summary>
        /// ݒ肳Ă邩킩Ȃm[h̃eLXg擾
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <param name="defaultValue"></param>
        /// <returns></returns>
        public static string GetTextOptionalDefault(XmlNode node,string path, string defaultValue)
        {
            if (node == null) return defaultValue;

            try
            {
                XmlNode target = node.SelectSingleNode(path);
                if (target == null) return defaultValue;
                return GetText(target);
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public static int GetInteger(XmlNode node)
        {
            if (node == null)
            {
                throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
            }

            string s = GetText(node);
            int intValue = NumberUtil.IntValue(s);
            return intValue;
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static int GetInteger(XmlNode node,string path)
        {
            if (node == null)
            {
                throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
            }

            try
            {
                XmlNode target = node.SelectSingleNode(path);
                if (target == null)
                {
                    throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
                }

                return NumberUtil.IntValue( GetText(target) );
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public static int GetIntegerOptional(XmlNode node)
        {
            return GetIntegerOptionalDefault(node,0);
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static int GetIntegerOptional(XmlNode node, string path)
        {
            return GetIntegerOptionalDefault(node, path, 0);
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="defaultValue"></param>
        /// <returns></returns>
        public static int GetIntegerOptionalDefault(XmlNode node,int defaultValue)
        {
            if (node == null) return defaultValue;

            string s = GetTextOptional(node);
            int intValue = NumberUtil.IntValue(s);
            return intValue;
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <param name="defaultValue"></param>
        /// <returns></returns>
        public static int GetIntegerOptionalDefault(XmlNode node, string path,int defaultValue)
        {
            if (node == null)
            {
                return defaultValue;
            }

            try
            {
                XmlNode target = node.SelectSingleNode(path);
                if (target == null)
                {
                    return defaultValue;
                }

                return GetIntegerOptionalDefault(target,defaultValue);
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public static decimal GetDecimalOptional(XmlNode node)
        {
            return GetDecimalOptionalDefault(node, 0M);
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static decimal GetDecimalOptional(XmlNode node, string path)
        {
            return GetDecimalOptionalDefault(node, path, 0);
        }

        /// <summary>
        /// m[h̒ldecimalɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="defaultValue"></param>
        /// <returns></returns>
        public static decimal GetDecimalOptionalDefault(XmlNode node, decimal defaultValue)
        {
            if (node == null) return defaultValue;

            string s = GetTextOptional(node);
            decimal value = NumberUtil.DecimalValue(s);
            return value;
        }
        /// <summary>
        /// m[h̒ldecimalɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <param name="defaultValue"></param>
        /// <returns></returns>
        public static decimal GetDecimalOptionalDefault(XmlNode node, string path, decimal defaultValue)
        {
            if (node == null)
            {
                return defaultValue;
            }

            try
            {
                XmlNode target = node.SelectSingleNode(path);
                if (target == null)
                {
                    return defaultValue;
                }

                return GetDecimalOptionalDefault(target, defaultValue);
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }
        /// <summary>
        /// m[h̒lboolɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public static bool GetBool(XmlNode node)
        {
            if (node == null)
            {
                throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
            }

            string s = GetText(node);
            bool value = NumberUtil.BoolValue(s);
            return value;
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static bool GetBool(XmlNode node, string path)
        {
            if (node == null)
            {
                throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
            }

            try
            {
                XmlNode target = node.SelectSingleNode(path);
                if (target == null)
                {
                    throw new Exception(ErrorCodeConst.ERR_ELEMENT_NOT_FOUND);
                }

                return NumberUtil.BoolValue(GetText(target));
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }

        /// <summary>
        /// m[h̒lboolɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <returns></returns>
        public static bool GetBoolOptional(XmlNode node)
        {
            if (node == null)
            {
                return false;
            }

            string s = GetText(node);
            bool value = NumberUtil.BoolValue(s);
            return value;
        }
        /// <summary>
        /// m[h̒l𐮐ɂĕԂ
        /// </summary>
        /// <param name="node"></param>
        /// <param name="path"></param>
        /// <returns></returns>
        public static bool GetBoolOptional(XmlNode node, string path)
        {
            if (node == null)
            {
                return false;
            }

            try
            {
                XmlNode target = node.SelectSingleNode(path);
                if (target == null)
                {
                    return false;
                }

                return NumberUtil.BoolValue(GetText(target));
            }
            catch (Exception ex)
            {
                ErrorMessageBuilder builder = ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw ex;
            }
        }

        static XmlNode FixNode(XmlNode node)
        {
            if (node.ChildNodes.Count == 0)
            {
                return node;
            }
            if (node.ChildNodes.Count == 1)
            {
                if (node.FirstChild.NodeType == XmlNodeType.Text)
                {
                    return node.FirstChild;
                }
                if (node.FirstChild.NodeType == XmlNodeType.CDATA)
                {
                    return node.FirstChild;
                }
                return node;
            }
            XmlNode cdataNode = null;
            foreach (XmlNode child in node.ChildNodes)
            {
                if (child.NodeType == XmlNodeType.CDATA)
                {
                    cdataNode = child;
                    break;
                }
            }
            if (cdataNode != null) return cdataNode;
            return node;

        }
    }
}
