using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;
using OFW.Util;

namespace OFW.Validators
{
    /// <summary>
    /// BytetB[hpValidator
    /// </summary>
    public class ByteFieldValidator : FieldValidator
    {
        /// <summary>
        /// ftHg\z
        /// </summary>
        public ByteFieldValidator() : base()
        {
            this.mProperty = new ByteFieldProperty();
        }
        /// <summary>
        /// vpeBw
        /// </summary>
        /// <param name="p"></param>
        public ByteFieldValidator(FieldProperty p) : base(p)
        {
        }
        /// <summary>
        /// ^Cv`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateType(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                if (aValue is byte) return true;
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);

                return false;
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
        }
        /// <summary>
        /// ͈̓`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateRange(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                ByteFieldProperty prop = (ByteFieldProperty)this.mProperty;
                byte checkVale = Byte.Parse(aValue.ToString());

                if (!TypeChecker.CheckNumeric(checkVale, prop.MinValue, prop.MaxValue))
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_RANGE"), prop.DisplayName, prop.MinValue, prop.MaxValue);
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
            return true;
        }
    }
}
