using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using OFW.Util;
using OFW.MessageResources;
using OFW.FieldProperties;

namespace OFW.Validators
{
    /// <summary>
    /// tB[h؂̂߂̒
    /// </summary>
    public abstract class FieldValidator
    {
        /// <summary>
        /// ،ʂŝƂ\郁bZ[W̌i[郊\[X
        /// </summary>
        protected MessageResource mResource;
        /// <summary>
        /// ΏۃtB[h̃vpeB
        /// </summary>
        protected FieldProperty mProperty;
        /// <summary>
        /// ؃G[̃bZ[W
        /// </summary>
        public string ErrorMessage;

        /// <summary>
        /// ftHg\z
        /// </summary>
        public FieldValidator()
        {
            this.mResource = MessageResourceFactory.GetInstance("common");
            //nh[Oݒ
            this.mProperty = null;
            this.ErrorMessage = "";

        }
        /// <summary>
        /// vpeBw
        /// </summary>
        /// <param name="p"></param>
        public FieldValidator(FieldProperty p)
        {
            this.mResource = MessageResourceFactory.GetInstance("common");
            //nh[Oݒ
            this.mProperty = p;
            this.ErrorMessage = "";

        }
        /// <summary>
        /// CX^X擾
        /// </summary>
        /// <param name="property">؂tB[hɑΉvpeB̃^Cv</param>
        /// <returns>w^CvɑΉK؂Ȍ^FieldProperty</returns>
        public static FieldValidator GetInstance(FieldProperty property)
        {
            //vpeB̃^CvValidator̎ۂ̃^Cv擾
            Type propertyType = property.GetType();
            Type t = Type.GetType(typeof(FieldValidator).Namespace + "." + BuildSubclassName(propertyType.Name));
            //nh[CX^X
            FieldValidator validator = (FieldValidator)System.Activator.CreateInstance(t);
            validator.mResource = MessageResourceFactory.GetInstance("common");
            //nh[Oݒ
            validator.mProperty = property;
            validator.ErrorMessage = "";
            return validator;
        }

        /// <summary>
        /// (helper)vpeB̃^Cv̂FieldValidator̃^CvgݗĂ
        /// </summary>
        /// <param name="TargetClassName">vpeB̃^Cv</param>
        /// <returns>gݗĂFieldValidator̃^Cv</returns>
        /// <remarks>
        /// ȉ̃[Ŗ̐<br />
        /// HogeProperty 
        /// ->Property؂
        /// ->Validator𑫂
        /// -> = HogeValidator
        /// </remarks>
        private static string BuildSubclassName(string TargetClassName){
            string subclassName = "";

            int cutPosition = TargetClassName.IndexOf("Property");
            if (cutPosition < 0) return "";

            string baseName = TargetClassName.Substring(0, cutPosition );

            subclassName = baseName + "Validator";

            return subclassName;
        }
        /// <summary>
        /// ؃WbN̒`
        /// </summary>
        /// <param name="aValue">ؑΏ</param>
        /// <returns>؂ɐƂtrue</returns>
        /// <remarks>
        /// ȉ̃WbNsB<br />
        /// 1) K{`FbN<br />
        /// 2) ^`FbN<br />
        /// 3) `FbN<br />
        /// 4) ͈̓`FbN<br />
        /// 5) tH[}bg`FbN<br />
        /// X̋ۃNXꂼ̓e`邱ƁB
        /// </remarks>
        public virtual bool Validate(object aValue)
        {
            this.ErrorMessage = "";
            if (this.mProperty.IgnoreValidation) return true;

            if (!this.mProperty.IsNullable)
            {
                if (!ValidateRequired(aValue))
                {
                    return false;
                }
            }
            //nullA󕶎ȂȉĂӖȂB
            //nullable=falseŒlnullȂValidateRequiredłЂ
            if (aValue == null) return true;

            if (aValue.ToString().Trim() == "") return true;
            if (!ValidateType(aValue))
            {
                return false;
            }

            if (!ValidateLength(aValue))
            {
                return false;
            }
            if (!ValidateRange(aValue))
            {
                return false;
            }
            if (!ValidateFormat(aValue))
            {
                return false;
            }
            return true;

        }
        /// <summary>
        /// K{`FbN
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public virtual bool ValidateRequired(object aValue)
        {
            this.ErrorMessage = "";
            if (aValue == null)
            {
                this.ErrorMessage = String.Format( mResource.GetString("ERR_REQUIRED_MISSING"),this.mProperty.DisplayName);
                return false;
            }
            if (aValue.ToString().Trim() == "")
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_REQUIRED_MISSING"), this.mProperty.DisplayName);
                return false;
            }

            //l^0invalid
            if ((this.mProperty.FieldType == typeof(byte))
                || (this.mProperty.FieldType == typeof(short))
                || (this.mProperty.FieldType == typeof(int))
                || (this.mProperty.FieldType == typeof(long))
                || (this.mProperty.FieldType == typeof(float))
                || (this.mProperty.FieldType == typeof(double))
                || (this.mProperty.FieldType == typeof(decimal))
                )
            {
                if (!this.mProperty.AllowZero)
                {
                    decimal d = NumberUtil.Value<decimal>(aValue);
                    if (d == 0)
                    {
                        this.ErrorMessage = String.Format(mResource.GetString("ERR_REQUIRED_MISSING"), this.mProperty.DisplayName);
                        return false;
                    }
                }
            }
            return true;
        }
        /// <summary>
        /// ^Cv`FbN
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public virtual bool ValidateType(object aValue)
        {
            this.ErrorMessage = "";
            return true;
        }
        /// <summary>
        /// ͈̓`FbN
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public virtual bool ValidateRange(object aValue)
        {
            this.ErrorMessage = "";
            return true;
        }
        /// <summary>
        /// `FbN
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public virtual bool ValidateLength(object aValue)
        {
            this.ErrorMessage = "";
            return true;
        }
        /// <summary>
        /// tH[}bg`FbN
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public virtual bool ValidateFormat(object aValue)
        {
            this.ErrorMessage = "";
            return true;
        }
        
    }


}
