using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using Sample.Data.Models;
using System.Reflection;
using Castle.Core;
using Castle.Core.Interceptor;
using Castle.DynamicProxy;
using CFW.Log;

namespace AssociationMapper
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            MastSiteModel siteModel = new MastSiteModel();
            List<MastSiteEntity> sites = siteModel.findAll1();
            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0");
            showResult(sites);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            MastSiteModel siteModel = new MastSiteModel();
            List<MastSiteEntity> sites = siteModel.findAll2();
            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0");

            showResult(sites);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            MastSiteModel siteModel = new MastSiteModel();
            List<MastSiteEntity> sites = siteModel.findAll3();
            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0");

            showResult(sites);

        }

        private void button4_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            MastMenuModel model = new MastMenuModel();
            List<MastMenuEntity> menus = model.findAll();
            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0");

            StringBuilder builder = new StringBuilder();
            foreach (MastMenuEntity menu in menus)
            {
                builder.Append(menu.site.siteCode);
                builder.Append(" ");
                builder.Append(menu.site.name);
                builder.Append(" ");
                builder.Append(menu.menuCode);
                builder.Append(" ");
                builder.Append(menu.name);
                builder.AppendLine();
                foreach (MastManuscriptEntity manuscript in menu.manuscripts)
                {
                    builder.Append("        ");
                    builder.Append(manuscript.seq);
                    builder.Append(" ");
                    builder.Append(manuscript.fromDate);
                    builder.Append("-");
                    builder.Append(manuscript.endDate);
                    builder.AppendLine();
                }
            }
            textBox1.Text = builder.ToString();

        }

        private void button5_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            MastSiteModel siteModel = new MastSiteModel();
            List<MastSiteEntity> sites = siteModel.findAll4();
            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0");
            showResult(sites);
        }
        void showResult(List<MastSiteEntity> sites)
        {
            StringBuilder builder = new StringBuilder();
            foreach (MastSiteEntity site in sites)
            {
                builder.Append(site.siteCode);
                builder.Append(" ");
                builder.Append(site.name);
                builder.AppendLine();
                foreach (MastMenuEntity menu in site.menus)
                {
                    builder.Append("    ");
                    builder.Append(menu.menuCode);
                    builder.Append(" ");
                    builder.Append(menu.name);
                    builder.AppendLine();
                    foreach (MastManuscriptEntity manuscript in menu.manuscripts)
                    {
                        builder.Append("        ");
                        builder.Append(manuscript.seq);
                        builder.Append(" ");
                        builder.Append(manuscript.fromDate);
                        builder.Append("-");
                        builder.Append(manuscript.endDate);
                        builder.AppendLine();
                    }
                }
            }
            textBox1.Text = builder.ToString();
        }

        private void button6_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            MastSiteModel siteModel = new MastSiteModel();
            List<MastSiteEntity> sites = siteModel.findAll();
            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString("#,##0");
            showResult(sites);

        }
    }
    public class SampleEntity
    {
        public int id;
        public string name;
    }
    public interface IModel
    {
        bool save(SampleEntity entity);
        SampleEntity find();
    }
    public class SampleModel : IModel
    {
        public virtual bool save(SampleEntity entity)
        {

            return false;
        }
        public virtual SampleEntity find()
        {
            return new SampleEntity();
        }
    }
    public class ProxyFactory
    {
        private static readonly IDictionary<object, Interceptor> _proxies = new Dictionary<object, Interceptor>();

        private static readonly ProxyGenerator _generator = new ProxyGenerator();
        public static T create<T>() where T : class, new()
        {
            Interceptor i = new Interceptor();

            T proxy = _generator.CreateClassProxy<T>(i);
            _proxies.Add(proxy, i);
            return proxy;
        }
    }
    [Serializable]
    public class Interceptor : IInterceptor
    {
        Logger logger = LoggerFactory.GetLogger("default", "intercepter");
        
        public void Intercept(IInvocation invocation)
        {
            logger.Debug(invocation.Method.Name, "start");
            invocation.Proceed();
            logger.Debug(invocation.Method.Name, "end");
        }
    }

}