using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.CommandBuilder;
namespace ConnectionTest.Models 
{
    /// <summary>
    /// Sample1 f`
    /// </summary>
    [Serializable()]
	public class Sample1Model : DbModel<Sample1Entity,Sample1Property>
	{
        /// <summary>
        /// default construct  
        /// </summary>
        public Sample1Model() : base()
        {
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public Sample1Model(CFW.Database.Connection connection)
            : base(connection)
        {
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public Sample1Model(CFW.Database.Connection connection, Sample1Property property)
            : base(connection, property)
        {
        }
        public List<Sample1Entity> find2()
        {
            try
            {
                this.connect("xe");
                ConditionFactory cf = new ConditionFactory(connection);
                DataSource<Sample1Entity> datasource = connection.getDataSource<Sample1Entity>();
                datasource.setProperty(property);

                return datasource.find(
                    new Criteria()
                    .where(cf.create( "id between :id1 and :id2",
                        new Parameter(":id1",1),
                        new Parameter(":id2",4)
                    )
                    )
                    .whereOr(cf.create( property.id, ":id3", 100, ">" ))
                    .orderBy(property.stringField1, "DESC")
                );

            }
            finally
            {

                this.disconnect();
            }
        }
        public List<Sample1Entity> find3(string cond)
        {
            try
            {
                this.connect("xe");
                ConditionFactory cf = new ConditionFactory(connection);
                DataSource<Sample1Entity> datasource = new DataSource<Sample1Entity>(connection, property);

                Criteria c = new Criteria()
                    .where(cf.create(property.stringField1, ":param1", connection.EscapeWildCards(cond) + "%" , "LIKE"))
                    .orderBy(property.stringField1, "DESC");

                return datasource.find(c);
            }
            finally
            {
                this.disconnect();
            }
        }

    }

}