using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;

namespace FormAdapterSample
{
    public partial class NumberInputTest : Form
    {
        NumberInputElement element1;
        NumberInputElement element2;
        NumberInputElement element3;
        NumberInputElement element4;

        public NumberInputTest()
        {
            InitializeComponent();

            element1 = new NumberInputElement(textBox1,5,0);
            element2 = new NumberInputElement(textBox2, 6, 2,"###0.00");
            element3 = new NumberInputElement(textBox3, 6, 2, "#,##0.00");
            element4 = new NumberInputElement(textBox4, 6, 2, "#,##0");
        }

        private void button1_Click(object sender, EventArgs e)
        {

            result1.Text = (element1.Validate(true)) ? CFW.Util.StringUtil.StringValue(element1.GetValue()) : element1.ErrorMessage;
            result2.Text = (element2.Validate(true)) ? CFW.Util.StringUtil.StringValue(element2.GetValue()) : element2.ErrorMessage;
            result3.Text = (element3.Validate(true)) ? CFW.Util.StringUtil.StringValue(element3.GetValue()) : element3.ErrorMessage;
            result4.Text = (element4.Validate(true)) ? CFW.Util.StringUtil.StringValue(element4.GetValue()) : element4.ErrorMessage;

        }

        private void button2_Click(object sender, EventArgs e)
        {
            decimal? newValue = CFW.Util.NumberUtil.Parse<decimal?>(newValueInput.Text);
            element1.SetValue(newValue, true);
            element2.SetValue(newValue, true);
            element3.SetValue(newValue, true);
            element4.SetValue(newValue, true);
        }
    }
}