using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Messaging;
using System.Runtime.Remoting.Proxies;
using System.Runtime.Remoting.Activation;
using System.Runtime.Remoting.Services;
using System.Reflection;
using System.Diagnostics;
using System.Reflection;
using System.Reflection.Emit;
using Castle.Core;
using Castle.Core.Interceptor;
using Castle.DynamicProxy;

namespace Interceptor
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            MyProxyClass mpc = new MyProxyClass(typeof(SampleClass));
            SampleClass o = mpc.GetTransparentProxy() as SampleClass;
            o.Print("");
            int n = o.Add(10, 20);
            Console.WriteLine(n.ToString());

            MyProxyClass mpc2 = new MyProxyClass(typeof(SampleClass2));
            SampleClass2 o2 = mpc2.GetTransparentProxy() as SampleClass2;
            o2.Print("");
            n = o.Add(10, 20);
            Console.WriteLine(n.ToString());
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            for (int i = 0; i < 10; i++)
            {
                SampleClass3 o = TypeWrapper.Wrap<SampleClass3>();
                o.Print("");
                int n = o.Add(10, 20);
            }
            sw.Stop();
            textBox1.AppendText(formatElapsed(sw) + Environment.NewLine);

        }

        private void button3_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            for (int i = 0; i < 10; i++)
            {
                SampleModel o = Factory.MakeFreezable<SampleModel>();
                o.find();
            }

            sw.Stop();
            textBox1.AppendText(formatElapsed(sw) + Environment.NewLine);
        }
        string formatElapsed(Stopwatch sw)
        {
            return ((double)sw.ElapsedTicks / (double)Stopwatch.Frequency).ToString("#,##0.000");
        }
    }

    public class SampleEntity
    {
        public int id;
        public string name;
    }
    public interface IModel
    {
        bool save(SampleEntity entity);
        SampleEntity find();
    }
    public class SampleModel : IModel
    {
        public virtual bool save(SampleEntity entity)
        {
            
            return false;
        }
        public virtual SampleEntity find()
        {
            return new SampleEntity();
        }
    }
    public class Factory
    {
        private static readonly IDictionary<object, Interceptor> _freezables = new Dictionary<object, Interceptor>();

        private static readonly ProxyGenerator _generator = new ProxyGenerator();
        public static T MakeFreezable<T>() where T: class, new()
        {
            Interceptor i = new Interceptor();
            
            T proxy = _generator.CreateClassProxy<T>(i);
            _freezables.Add(proxy, i);
            return proxy;
        }
    }
    [Serializable]
    public class Interceptor : IInterceptor
    {
        public void Intercept(IInvocation invocation)
        {
            invocation.Method.GetCustomAttributes();
            Console.WriteLine("Before target call");
            invocation.Proceed();
            Console.WriteLine("After target call");
        }
    }

    /// <summary>
    /// T̉z֐bvA\bh\NX
    /// </summary>
    class TypeWrapper
    {
        private static Dictionary<string, Type> dict = new Dictionary<string, Type>();

        public static T Wrap<T>() where T : class, new()
        {
            Type t = typeof(T);
            Type wt;

            // NXWrappedt
            string name = "Wrapped" + t.Name;
            // ɍ쐬ς݂̃bvNXH
            if (dict.TryGetValue(name, out wt))
                return Activator.CreateInstance(wt) as T;

            AssemblyBuilder ab = AppDomain.CurrentDomain.DefineDynamicAssembly(
                new AssemblyName("Wrapped" + t.Name + "Assembly"), AssemblyBuilderAccess.Run);
            ModuleBuilder md = ab.DefineDynamicModule(
                "Wrapped" + t.Name + "Module");
            TypeBuilder tb = md.DefineType("Wrapped" + t.Name, TypeAttributes.Class, t);
            tb.DefineDefaultConstructor(MethodAttributes.Public);

            foreach (MethodInfo mi in t.GetMethods(
                BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance))
            {
                // z֐̂݃I[o[Ch
                if (mi.IsVirtual)
                {
                    // p[^̌^
                    ParameterInfo[] pis = mi.GetParameters();
                    Type[] types = new Type[pis.Length];
                    for (int i = 0; i < pis.Length; ++i)
                        types[i] = pis[i].ParameterType;

                    // \bh̃VOl`̓I[o[ChΏۂƓ    
                    MethodBuilder mb = tb.DefineMethod(mi.Name, mi.Attributes,
                        mi.CallingConvention, mi.ReturnParameter.ParameterType, types);

                    ILGenerator il = mb.GetILGenerator();
                    // 荞Ń\bh\
                    il.EmitWriteLine(t.Name + "#" + mi.Name + " start");
                    // p[^X^bNɐς
                    // thisp[^X^bNɐςނ̂+1Ă
                    for (int i = 0; i < pis.Length + 1; ++i)
                        il.Emit(OpCodes.Ldarg, i);
                    // x[XNX̃\bhĂяo
                    il.Emit(OpCodes.Call, mi);
                    il.EmitWriteLine(t.Name + "#" + mi.Name + " end");
                    il.Emit(OpCodes.Ret);

                    // I[o[Ch
                    tb.DefineMethodOverride(mb, mi);
                }
            }
            wt = tb.CreateType();
            dict[name] = wt;
            return Activator.CreateInstance(wt) as T;
        }
    }


    public class SampleClass : MarshalByRefObject
    {
        public virtual void Print(string s)
        {
            //Console.WriteLine(s);
        }
        public virtual int Add(int a, int b)
        {
            return a + b;
        }
    }
    public class SampleClass2 : SampleClass
    {
        public override void Print(string s)
        {
            Console.WriteLine(s);
            Console.WriteLine(s);
            int n = Add(100, 200);
            Console.WriteLine(n.ToString());
        }
        public override int Add(int a, int b)
        {
            return a + b;
        }
    }
    public class SampleClass3
    {
        public virtual void Print(string s)
        {
            //Console.WriteLine(s);
        }
        public virtual int Add(int a, int b)
        {
            return a + b;
        }
    }

    public class MyProxyClass : RealProxy
    {
        private Object myObjectInstance = null;
        private Type myType = null;

        public MyProxyClass(Type argType)
            : base(argType)
        {
            myType = argType;
            myObjectInstance = Activator.CreateInstance(argType);
        }

        public override IMessage Invoke(IMessage message)
        {
            IMethodMessage myMethodMessage = (IMethodMessage)message;

            Object returnValue = myType.InvokeMember(myMethodMessage.MethodName,
                                     BindingFlags.InvokeMethod, null, myObjectInstance,
                                     myMethodMessage.Args);
            ReturnMessage myReturnMessage = new ReturnMessage(returnValue, null, 0,
                                     ((IMethodCallMessage)message).LogicalCallContext,
                                     (IMethodCallMessage)message);
            return myReturnMessage;
        }
    }

    [BusinessLogicProxy()]
    public class BusinessLogic : ContextBoundObject
    {
        [TimeLimit]
        public string GetMessage1()
        {
            return DateTime.Now.ToString();
        }

        [TimeLimit]
        public string GetMessage2()
        {
            return DateTime.Now.DayOfWeek.ToString();
        }
    }
    class BusinessLogicProxy : RealProxy
    {
        private readonly BusinessLogic _target;

        /// <summary>  
        /// RXgN^  
        /// </summary>  
        /// <param name="target">ΏۂBussinessLogicIuWFNg</param>  
        /// <param name="t">BussinessLogič^</param>  
        public BusinessLogicProxy(BusinessLogic target, Type t)
            : base(t)
        {
            _target = target;
        }

        /// <summary>  
        /// ۂ̃\bhĂяo܂B  
        /// </summary>  
        /// <param name="request">IMessage</param>  
        /// <returns>IMessage</returns>  
        public override IMessage Invoke(IMessage request)
        {
            IMessage response = null;

            IMethodCallMessage call = (IMethodCallMessage)request;

            IConstructionCallMessage ctor = call as IConstructionCallMessage;

            if (ctor != null)
            {
                // CX^XȂꍇ́ARXgN^s  
                RealProxy rp = RemotingServices.GetRealProxy(_target);
                rp.InitializeServerObject(ctor);
                MarshalByRefObject tp = this.GetTransparentProxy() as MarshalByRefObject;
                response = EnterpriseServicesHelper.CreateConstructionReturnMessage(ctor, tp);
            }
            else
            {
                response = Invoke(call);
            }

            return response;

        }

        /// <summary>  
        /// sۂ̔fsĂA\bhs܂B  
        /// </summary>  
        /// <param name="call">\bhR[bZ[W</param>  
        private IMessage Invoke(IMethodCallMessage call)
        {
            ReturnMessage response;

            // 擾  
            TimeLimitAttribute timelimitAttr = GetAttribute(call.MethodBase);

            if (timelimitAttr.CanInvoke())
            {
                //\bhs  
                response = RemotingServices.ExecuteMessage(_target, call) as ReturnMessage;
            }
            else
            {
                string str = timelimitAttr.CreateResponse();

                // \bh͎sȂ  
                ReturnMessage rm = new ReturnMessage(str, null, 0, call.LogicalCallContext, call);
                return rm;

            }

            if (response.Exception != null)
            {
                throw response.Exception;
            }

            return response;
        }

        /// <summary>  
        /// 擾܂B  
        /// </summary>  
        /// <param name="m">\bh</param>  
        /// <returns>\bhɕtĂ鑮Bw肪ȂꍇNullTimeLimitAttributeԂ܂B</returns>  
        private TimeLimitAttribute GetAttribute(MethodBase m)
        {
            object[] atts = m.GetCustomAttributes(true);
            TimeLimitAttribute timelimitAttr = null;

            if (atts.Length > 0)
            {
                timelimitAttr = atts[0] as TimeLimitAttribute;
            }

            if (timelimitAttr == null)
            {
                timelimitAttr = new NullTimeLimitAttribute();
            }
            return timelimitAttr;
        }
    }
    [AttributeUsage(AttributeTargets.Class)]
    public sealed class BusinessLogicProxyAttribute : ProxyAttribute
    {
        /// <summary>  
        /// RXgN^  
        /// </summary>  
        public BusinessLogicProxyAttribute()
        {
        }

        /// <summary>  
        /// ߃vLVIuWFNg𐶐܂B  
        /// </summary>  
        /// <param name="t">^[QbgNX̃^Cv</param>  
        /// <returns>߃vLVIuWFNg</returns>  
        public override MarshalByRefObject CreateInstance(Type t)
        {
            MarshalByRefObject target = base.CreateInstance(t) as MarshalByRefObject;

            BusinessLogicProxy proxy = new BusinessLogicProxy((BusinessLogic)target, t);
            return (MarshalByRefObject)proxy.GetTransparentProxy();
        }
    }


    public class TimeLimitAttribute : System.Attribute
    {
        /// <summary>  
        /// pۂ𔻒f܂B  
        /// </summary>  
        public virtual bool CanInvoke()
        {
            bool canUse = false; //ps  
            DateTime now = DateTime.Now;

            if (now.Second < 30)
            {
                //ԊȌꍇ  
                canUse = true; //p  
            }
            return canUse;

        }

        /// <summary>  
        /// NCAgɕԂbZ[W쐬܂  
        /// </summary>  
        /// <returns>ps̂ƂɕԂbZ[W</returns>  
        public virtual string CreateResponse()
        {
            return "݁A̋@\͎g܂B";
        }
    }

    /// <summary>  
    /// ȂƂ錾܂B  
    /// tȂ\bhɓKp܂B  
    /// </summary>  
    public sealed class NullTimeLimitAttribute : TimeLimitAttribute
    {
        /// <summary>  
        /// RXgN^  
        /// </summary>  
        public NullTimeLimitAttribute() { }


        public override bool CanInvoke()
        {
            return true;//łp\  
        }

        public override string CreateResponse()
        {
            return null;
        }


    }  

}