using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableAccess;
using Konozama.Shop.Model.TableProperty;
using Konozama.Shop.Model.TableValidator;
using Konozama.Shop.Model.Entity;

namespace Konozama.Shop.Model.Access
{
    /// <summary>
    /// Orders ANZX`
    /// </summary>
    [Serializable()]
	public class OrdersAccess
	{
        Connection connection;
        /// <summary>
        /// ۑ
        /// </summary>
        /// <param name="order">ۑ钍f[^</param>
        /// <returns></returns>
        public int Save(OrdersEntity order)
        {
            connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            try{
                //ݒvpeB̐ݒ
                order.OrderDate = DateTime.Now;
                order.Id = NewId();

                //wb_[f[^x[Xɑ}
                OrdersTableAccess tableAccess = new OrdersTableAccess(this.connection);
                int result = tableAccess.Insert(order);

                //ו
                OrderItemsAccess itemAccess = new OrderItemsAccess(this.connection);
                foreach (OrderItemsEntity item in order.Items)
                {
                    item.OrderId = order.Id;

                    result +=itemAccess.Save(item);
                }

                return result;
            }
            finally
            {
                connection.Close();
            }

        }
        /// <summary>
        /// VID𐶐
        /// </summary>
        /// <returns>VID</returns>
        int NewId()
        {
            try
            {

                Command command = new Command("select isnull(max(id),0) + 1 from orders", CommandType.Text);
                return CFW.Util.NumberUtil.Value<int>(connection.ExecuteScalar(command));
            }
            finally
            {
            }

        }
    }

}