using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;

namespace Konozama.Shop.Model.TableProperty
{
    /// <summary>
    /// table order_itemsɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class OrderItemsTableProperty : FieldPropertiesBase
    {
    	///<summary>ftHg̃e[u</summary>
    	string DefaultTableName;
		///<summary>[id]</summary>
		public FieldProperty Id;
		///<summary>[order_id]</summary>
		public FieldProperty OrderId;
		///<summary>[product_id]</summary>
		public FieldProperty ProductId;
		///<summary>[unit_price]</summary>
		public FieldProperty UnitPrice;
		///<summary>[quantity]</summary>
		public FieldProperty Quantity;
		///<summary>[price]</summary>
		public FieldProperty Price;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public OrderItemsTableProperty()
        {
        	this.DefaultTableName = "order_items";
			Id = FieldProperty.NewInstance("int", "order_items", "id","[id]", 4, 10, 0, false, 0,true);
			OrderId = FieldProperty.NewInstance("int", "order_items", "order_id","[order_id]", 4, 10, 0, true, null,false);
			ProductId = FieldProperty.NewInstance("int", "order_items", "product_id","[product_id]", 4, 10, 0, true, null,false);
			UnitPrice = FieldProperty.NewInstance("decimal", "order_items", "unit_price","[unit_price]", 12, 10, 0, true, null,false);
			Quantity = FieldProperty.NewInstance("decimal", "order_items", "quantity","[quantity]", 12, 10, 0, true, null,false);
			Price = FieldProperty.NewInstance("decimal", "order_items", "price","[price]", 12, 10, 0, true, null,false);
			
        }

	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate()
        {
        	this.SetUpdate(true);
        }
	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate(bool doUpdate)
        {
			Id.DoUpdate = doUpdate;
			OrderId.DoUpdate = doUpdate;
			ProductId.DoUpdate = doUpdate;
			UnitPrice.DoUpdate = doUpdate;
			Quantity.DoUpdate = doUpdate;
			Price.DoUpdate = doUpdate;
			
        }
	    /// <summary>
	    /// TableNameꊇݒ
	    /// TableCommandgꍇAliasꊇݒ肷B
	    /// </summary>
	    /// <param name="alias">Vɐݒ肷e[u</param>
        public void SetTableName(string alias)
        {
			Id.TableName = alias;
			OrderId.TableName = alias;
			ProductId.TableName = alias;
			UnitPrice.TableName = alias;
			Quantity.TableName = alias;
			Price.TableName = alias;
			
        }
	    /// <summary>
	    /// TableName߂
	    /// </summary>
        public void ResetTableName()
        {
        	this.SetTableName(this.DefaultTableName);
        }
	    /// <summary>
	    /// e[uIR}hɑSĂ̗I悤Ɏw
	    /// </summary>
        public void SetSelectTo(ref CFW.Database.TableCommand.TableSelectCommand command)
        {
			command.AddSelect(this.Id);
			command.AddSelect(this.OrderId);
			command.AddSelect(this.ProductId);
			command.AddSelect(this.UnitPrice);
			command.AddSelect(this.Quantity);
			command.AddSelect(this.Price);
			
        }
    }
}