using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;

namespace Konozama.Shop.Model.TableProperty
{
    /// <summary>
    /// table productsɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class ProductsTableProperty : FieldPropertiesBase
    {
    	///<summary>ftHg̃e[u</summary>
    	string DefaultTableName;
		///<summary>[id]</summary>
		public FieldProperty Id;
		///<summary>[name]</summary>
		public FieldProperty Name;
		///<summary>[unit_price]</summary>
		public FieldProperty UnitPrice;
		///<summary>[description]</summary>
		public FieldProperty Description;
		///<summary>[category_id]</summary>
		public FieldProperty CategoryId;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public ProductsTableProperty()
        {
        	this.DefaultTableName = "products";
			Id = FieldProperty.NewInstance("int", "products", "id","[id]", 4, 10, 0, false, 0,true);
			Name = FieldProperty.NewInstance("varchar", "products", "name","[name]", 100, 0, 0, true, "",false);
			UnitPrice = FieldProperty.NewInstance("decimal", "products", "unit_price","[unit_price]", 12, 10, 0, true, null,false);
			Description = FieldProperty.NewInstance("varchar", "products", "description","[description]", 500, 0, 0, true, "",false);
			CategoryId = FieldProperty.NewInstance("int", "products", "category_id","[category_id]", 4, 10, 0, true, null,false);
			
        }

	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate()
        {
        	this.SetUpdate(true);
        }
	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate(bool doUpdate)
        {
			Id.DoUpdate = doUpdate;
			Name.DoUpdate = doUpdate;
			UnitPrice.DoUpdate = doUpdate;
			Description.DoUpdate = doUpdate;
			CategoryId.DoUpdate = doUpdate;
			
        }
	    /// <summary>
	    /// TableNameꊇݒ
	    /// TableCommandgꍇAliasꊇݒ肷B
	    /// </summary>
	    /// <param name="alias">Vɐݒ肷e[u</param>
        public void SetTableName(string alias)
        {
			Id.TableName = alias;
			Name.TableName = alias;
			UnitPrice.TableName = alias;
			Description.TableName = alias;
			CategoryId.TableName = alias;
			
        }
	    /// <summary>
	    /// TableName߂
	    /// </summary>
        public void ResetTableName()
        {
        	this.SetTableName(this.DefaultTableName);
        }
	    /// <summary>
	    /// e[uIR}hɑSĂ̗I悤Ɏw
	    /// </summary>
        public void SetSelectTo(ref CFW.Database.TableCommand.TableSelectCommand command)
        {
			command.AddSelect(this.Id);
			command.AddSelect(this.Name);
			command.AddSelect(this.UnitPrice);
			command.AddSelect(this.Description);
			command.AddSelect(this.CategoryId);
			
        }
    }
}