using System;
using System.Collections.Generic;
using System.Text;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Validators;
using CFW.Database;
using CFW.Database.TableCommand;

using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;

namespace Konozama.Shop.Model.TableValidator
{
    /// <summary>
    /// table[order_items]ɑ΂錟
    /// </summary>
    public class OrderItemsTableValidator : CFW.Validators.ValidatorBase
    {
        protected OrderItemsTableRow target;
        protected OrderItemsTableProperty property;
        
        /// <summary>
        /// \z
        /// </summary>
        public OrderItemsTableValidator()
            : base()
        {
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="target"></param>
        public OrderItemsTableValidator(OrderItemsTableRow target)
            : base()
        {
            this.target = target;
            this.property = new OrderItemsTableProperty();
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="target"></param>
        /// <param name="property"></param>
        public OrderItemsTableValidator(OrderItemsTableRow target, OrderItemsTableProperty property) : base()
        {
            
            this.target = target;
            this.property = property;
        }
        /// <summary>
        /// OrderItems
        /// 1łvalidłȂȂfalseԂBG[e͔ErrorMessagesɊi[B
        /// </summary>
        /// <returns></returns>
        public override bool Validate()
        {
            bool valid = true; //not validfalseɐg𗎂Ƃ
            FieldValidator validator = null;
            validator = FieldValidator.GetInstance(this.property.Id);
            if (!validator.Validate(this.target.Id))
            {
                this.ErrorMessages.Add(validator.ErrorMessage);
                valid = false;
            }
            validator = FieldValidator.GetInstance(this.property.OrderId);
            if (!validator.Validate(this.target.OrderId))
            {
                this.ErrorMessages.Add(validator.ErrorMessage);
                valid = false;
            }
            validator = FieldValidator.GetInstance(this.property.ProductId);
            if (!validator.Validate(this.target.ProductId))
            {
                this.ErrorMessages.Add(validator.ErrorMessage);
                valid = false;
            }
            validator = FieldValidator.GetInstance(this.property.UnitPrice);
            if (!validator.Validate(this.target.UnitPrice))
            {
                this.ErrorMessages.Add(validator.ErrorMessage);
                valid = false;
            }
            validator = FieldValidator.GetInstance(this.property.Quantity);
            if (!validator.Validate(this.target.Quantity))
            {
                this.ErrorMessages.Add(validator.ErrorMessage);
                valid = false;
            }
            validator = FieldValidator.GetInstance(this.property.Price);
            if (!validator.Validate(this.target.Price))
            {
                this.ErrorMessages.Add(validator.ErrorMessage);
                valid = false;
            }
            

            return valid;
        }
    }
}
