using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CFW.Models;
using CFW.Windows;
using CFW.Windows.Forms.Adapters;
using CFW.Forms.Filters;

using TaskManager.Models;
using TaskManager.Windows.Forms.Adapters;
using TaskManager.Forms;

namespace TaskManager
{
    public partial class TaskEdit : Form
    {
        private TasksEntity task;
        private TasksProperty taskProperty;
        private TasksFormAdapter formAdapter;
        private Enumerations priorityEnumerations;
        private Enumerations statusEnumerations;
        private Enumerations categoryEnumerations;

        public delegate void EditCompleteDelegate();
        public EditCompleteDelegate EditComplete;

        private WindowDragger dragger;

        public TaskEdit()
        {
            InitializeComponent();
            taskProperty = new TasksProperty();
            initializeFormAdapter();
            loadEnumerations();
            initializeView();

            dragger = new WindowDragger(this,customHeader);
            dragger.addHandle(customWindowTitle);
        }
        public void New()
        {
            TasksModel model = new TasksModel();
            task = model.NewTask();

            formAdapter.SetEntity(task);
            formAdapter.RenderView();

            operationMessageLabel.Text = "V^XN쐬܂B";

        }
        public void Edit(int taskId)
        {
            TasksModel model = new TasksModel();
            task = new TasksEntity();
            task.id = taskId;
            task = model.get(task);

            formAdapter.SetEntity(task);
            formAdapter.RenderView();

            operationMessageLabel.Text = "^XNҏW܂B";
        }
        public void Save()
        {

            task.IsModified = true;
            TasksModel model = new TasksModel();
            if (model.validate(task))
            {
                model.save(task);
                showOperationCompleteMessage();
                if (EditComplete != null) EditComplete();
            }
            else
            {
                showErrorMessage(model.messages);
            }

        }
        private void loadEnumerations()
        {
            CategoriesModel categories = new CategoriesModel();
            categoryEnumerations = categories.getEnumerations();

            StatusesModel statuses = new StatusesModel();
            statusEnumerations = statuses.getEnumerations();

            PrioritiesModel priorities = new PrioritiesModel();
            priorityEnumerations = priorities.getEnumerations();

        }
        private void initializeFormAdapter()
        {
            formAdapter = new TasksFormAdapter();
            formAdapter.subject = new TextBoxAdapterElement(subjectInput,
                new CFW.Forms.Filters.StringFilter(taskProperty.subject, CFW.Util.StringUtil.NormalizeMode.TrimAll, true),
                CFW.Validators.FieldValidator.GetInstance(taskProperty.subject)
                );

            formAdapter.fromDate = new TextBoxAdapterElement(fromDateInput,
                new CFW.Forms.Filters.DateTimeFilter("yyyy/M/d", false),
                CFW.Validators.FieldValidator.GetInstance(taskProperty.fromDate),
                "yyyy/MM/dd"
                
                );
            formAdapter.fromDate.FilterOnBlur = true;

            formAdapter.toDate = new TextBoxAdapterElement(toDateInput,
                new CFW.Forms.Filters.DateTimeFilter("yyyy/M/d", false),
                CFW.Validators.FieldValidator.GetInstance(taskProperty.toDate),
                "yyyy/MM/dd"
                );
            formAdapter.toDate.FilterOnBlur = true;

            formAdapter.categoryId = new DropDownListAdapterElement(categorySelect, 
                new NumberFilter<int>(taskProperty.categoryId),
                CFW.Validators.FieldValidator.GetInstance(taskProperty.categoryId)
                );
            formAdapter.priority = new RadioButtonListAdapterElement(priorityInput);
            formAdapter.statusId = new RadioButtonListAdapterElement(statusInput);

            //ȉ͂Ȃ
            formAdapter.createdAt = new NullAdapterElement();
            formAdapter.createdBy = new NullAdapterElement();
            formAdapter.modifiedAt = new NullAdapterElement();
            formAdapter.modifiedBy = new NullAdapterElement();
            formAdapter.deleted = new NullAdapterElement();
            formAdapter.description = new NullAdapterElement(); //Ƃ肠͂Ȃǂ̂邩


        }
        private void initializeView()
        {
            categorySelect.DisplayMember = "name";
            categorySelect.ValueMember = "id";
            categorySelect.DataSource = categoryEnumerations;
            categorySelect.Refresh();

            priorityInput.DataSource = priorityEnumerations;
            priorityInput.Refresh();

            statusInput.DataSource = statusEnumerations;
            statusInput.Refresh();
        }
        private void button3_Click(object sender, EventArgs e)
        {
            //TODO: dirty check
            Hide();
        }

        private void panel6_MouseDown(object sender, MouseEventArgs e)
        {
        }

        private void panel6_MouseUp(object sender, MouseEventArgs e)
        {
        }

        private void button4_Click(object sender, EventArgs e)
        {
            formAdapter.ResetValidation();
            formAdapter.Bind();
            if (formAdapter.IsValid)
            {
                showOperationStartMessage();
                Save();
            }
            else
            {
                showErrorMessage(formAdapter.Messages);
            }
        }
        private void showErrorMessage(List<string> messages)
        {
            Point p = this.Location;
            p.X += this.Width / 2;
            p.Y += this.Height / 2;

 
            using (ErrorMessageForm form = new ErrorMessageForm())
            {
                form.StartPosition = FormStartPosition.Manual;
                form.Location = p;
                form.messages = messages;
                form.ShowDialog(this);
            }

        }
        private void showOperationCompleteMessage()
        {
            if (task.isClosed)
            {
                operationMessageLabel.Text = "^XNI܂B";
                return;
            }
            operationMessageLabel.Text = "^XNύX܂B";

        }
        private void showOperationStartMessage()
        {
            operationMessageLabel.Text = "ۑĂ܂...";
        }

        private void subjectInput_Leave(object sender, EventArgs e)
        {

        }

        private void container_Paint(object sender, PaintEventArgs e)
        {
            using (Pen pen = new Pen(Color.Silver,1))
            {
                Rectangle rect = container.ClientRectangle;
                rect.Width--;
                rect.Height--;
                e.Graphics.DrawRectangle(pen, rect);

            }
            
        }


    }
}